/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.BerPacket;
import com.davfx.ninio.snmp.BerPacketUtils;
import java.nio.ByteBuffer;

public final class IntegerBerPacket
implements BerPacket {
    private final ByteBuffer lengthBuffer;
    private final int length;
    private final int val;
    private final int m;

    public IntegerBerPacket(int value) {
        int mask = -8388608;
        int l = 4;
        while (((value & mask) == 0 || (value & mask) == mask) && l > 1) {
            --l;
            value <<= 8;
        }
        mask = -16777216;
        this.length = l;
        this.val = value;
        this.m = mask;
        this.lengthBuffer = BerPacketUtils.lengthBuffer(this.length);
    }

    @Override
    public void write(ByteBuffer buffer) {
        BerPacketUtils.writeHeader(2, this.lengthBuffer, buffer);
        int v = this.val;
        for (int i = 0; i < this.length; ++i) {
            buffer.put((byte)((v & this.m) >>> 24));
            v <<= 8;
        }
    }

    @Override
    public ByteBuffer lengthBuffer() {
        return this.lengthBuffer;
    }

    @Override
    public int length() {
        return this.length;
    }
}

