/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.google.common.base.Splitter;
import java.util.List;

public final class Oid
implements Comparable<Oid> {
    private final int[] raw;

    public Oid(String dotNotation) {
        List s = Splitter.on((char)'.').splitToList((CharSequence)dotNotation);
        this.raw = new int[s.size()];
        int i = 0;
        for (String e : s) {
            this.raw[i] = Integer.parseInt(e);
            ++i;
        }
    }

    public Oid(int[] raw) {
        this.raw = raw;
    }

    public int[] getRaw() {
        return this.raw;
    }

    public Oid sub(Oid child) {
        if (child.raw.length <= this.raw.length) {
            return null;
        }
        for (int i = 0; i < this.raw.length; ++i) {
            if (this.raw[i] == child.raw[i]) continue;
            return null;
        }
        int[] r = new int[child.raw.length - this.raw.length];
        System.arraycopy(child.raw, this.raw.length, r, 0, r.length);
        return new Oid(r);
    }

    public Oid append(Oid suffix) {
        int[] r = new int[this.raw.length + suffix.raw.length];
        System.arraycopy(this.raw, 0, r, 0, this.raw.length);
        System.arraycopy(suffix.raw, 0, r, this.raw.length, suffix.raw.length);
        return new Oid(r);
    }

    public int hashCode() {
        int h = 0;
        for (int e : this.raw) {
            h += e;
        }
        return h / this.raw.length;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (int e : this.raw) {
            if (b.length() > 0) {
                b.append('.');
            }
            b.append(String.valueOf(e));
        }
        return b.toString();
    }

    public boolean isPrefix(Oid oid) {
        if (oid.raw.length < this.raw.length) {
            return false;
        }
        for (int i = 0; i < this.raw.length; ++i) {
            if (this.raw[i] == oid.raw[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Oid)) {
            return false;
        }
        Oid oid = (Oid)o;
        if (oid.raw.length != this.raw.length) {
            return false;
        }
        for (int i = 0; i < this.raw.length; ++i) {
            if (this.raw[i] == oid.raw[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Oid handledOid) {
        int i;
        int[] handledOidRaw = handledOid.getRaw();
        for (i = 0; i < this.raw.length && i < handledOidRaw.length; ++i) {
            int h = handledOidRaw[i];
            int o = this.raw[i];
            if (h > o) {
                return -1;
            }
            if (h >= o) continue;
            return 1;
        }
        if (i < this.raw.length) {
            return 1;
        }
        if (i < handledOidRaw.length) {
            return -1;
        }
        return 0;
    }
}

