/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.BerPacket;
import com.davfx.ninio.snmp.BerPacketUtils;
import com.davfx.ninio.snmp.Oid;
import java.nio.ByteBuffer;

public final class OidBerPacket
implements BerPacket {
    private static final int MAX_OID_BUFFER_SIZE = 1024;
    private final ByteBuffer lengthBuffer;
    private final int length;
    private final ByteBuffer bb;

    public OidBerPacket(Oid oid) {
        int[] raw = oid.getRaw();
        if (raw.length < 2) {
            throw new IllegalArgumentException();
        }
        this.bb = ByteBuffer.allocate(1024);
        this.bb.put((byte)(raw[1] + raw[0] * 40 & 0xFF));
        for (int i = 2; i < raw.length; ++i) {
            int value = raw[i];
            int mask = -129;
            int bits = 0;
            while ((value & (mask <<= 7)) != 0) {
                bits += 7;
            }
            while (bits >= 0) {
                int b = value >>> bits & 0xFFFFFF7F;
                if (bits > 0) {
                    b |= 0x80;
                }
                this.bb.put((byte)b);
                bits -= 7;
            }
        }
        this.bb.flip();
        this.length = this.bb.remaining();
        this.lengthBuffer = BerPacketUtils.lengthBuffer(this.length);
    }

    @Override
    public void write(ByteBuffer buffer) {
        BerPacketUtils.writeHeader(6, this.lengthBuffer, buffer);
        int p = this.bb.position();
        buffer.put(this.bb);
        this.bb.position(p);
    }

    @Override
    public ByteBuffer lengthBuffer() {
        return this.lengthBuffer;
    }

    @Override
    public int length() {
        return this.length;
    }
}

