/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.DatagramReadyFactory;
import com.davfx.ninio.core.Queue;
import com.davfx.ninio.core.ReadyFactory;
import com.davfx.ninio.snmp.AuthRemoteEngine;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.Result;
import com.davfx.ninio.snmp.SnmpClient;
import com.davfx.ninio.snmp.SnmpClientHandler;
import com.davfx.util.ConfigUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;

public final class Snmp {
    private static final Config CONFIG = ConfigFactory.load((ClassLoader)Snmp.class.getClassLoader());
    public static final int DEFAULT_PORT = 161;
    private static final Queue DEFAULT_QUEUE = new Queue();
    private Queue queue = DEFAULT_QUEUE;
    private double timeoutFromBeginning = ConfigUtils.getDuration((Config)CONFIG, (String)"ninio.snmp.defaultTimeoutFromBeginning");
    private Address address = new Address("127.0.0.1", 161);
    private ReadyFactory readyFactory = new DatagramReadyFactory();
    private String community = CONFIG.getString("ninio.snmp.defaultCommunity");
    private AuthRemoteEngine authEngine = null;

    public Snmp withQueue(Queue queue) {
        this.queue = queue;
        return this;
    }

    public Snmp to(Address address) {
        this.address = address;
        return this;
    }

    public Snmp timeout(double timeoutFromBeginning) {
        this.timeoutFromBeginning = timeoutFromBeginning;
        return this;
    }

    public Snmp override(ReadyFactory readyFactory) {
        this.readyFactory = readyFactory;
        return this;
    }

    public Snmp withCommunity(String community) {
        this.community = community;
        return this;
    }

    public Snmp withLoginPassword(String authLogin, String authPassword, String authDigestAlgorithm, String privLogin, String privPassword, String privEncryptionAlgorithm) {
        this.authEngine = new AuthRemoteEngine(authLogin, authPassword, authDigestAlgorithm, privLogin, privPassword, privEncryptionAlgorithm);
        return this;
    }

    public SnmpClient client() {
        if (this.authEngine != null) {
            return new SnmpClient(this.queue, this.readyFactory, this.address, this.authEngine, this.timeoutFromBeginning);
        }
        return new SnmpClient(this.queue, this.readyFactory, this.address, this.community, this.timeoutFromBeginning);
    }

    public void get(final Oid oid, final SnmpClientHandler.Callback.GetCallback getCallback) {
        final SnmpClient client = this.client();
        client.connect(new SnmpClientHandler(){

            public void failed(IOException e) {
                getCallback.failed(e);
            }

            public void close() {
                getCallback.failed(new IOException("Prematurely closed"));
            }

            @Override
            public void launched(final SnmpClientHandler.Callback callback) {
                callback.get(oid, new SnmpClientHandler.Callback.GetCallback(){

                    public void failed(IOException e) {
                        callback.close();
                        client.close();
                        getCallback.failed(e);
                    }

                    public void close() {
                        callback.close();
                        client.close();
                        getCallback.close();
                    }

                    @Override
                    public void result(Result result) {
                        getCallback.result(result);
                    }
                });
            }
        });
    }
}

