/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Closeable;
import com.davfx.ninio.core.CloseableByteBufferHandler;
import com.davfx.ninio.core.DatagramReady;
import com.davfx.ninio.core.FailableCloseableByteBufferHandler;
import com.davfx.ninio.core.Queue;
import com.davfx.ninio.core.QueueReady;
import com.davfx.ninio.core.Ready;
import com.davfx.ninio.core.ReadyConnection;
import com.davfx.ninio.snmp.BerPacket;
import com.davfx.ninio.snmp.BerPacketUtils;
import com.davfx.ninio.snmp.BerReader;
import com.davfx.ninio.snmp.BytesBerPacket;
import com.davfx.ninio.snmp.IntegerBerPacket;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.OidBerPacket;
import com.davfx.ninio.snmp.SequenceBerPacket;
import com.davfx.util.Pair;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnmpServer
implements AutoCloseable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnmpServer.class);
    private static final int NO_SUCH_NAME_ERROR = 2;
    private final Queue queue;
    private CloseableByteBufferHandler write = null;
    private boolean closed = false;

    public SnmpServer(Address address, Handler handler) {
        this(new Queue(), address, handler);
    }

    public SnmpServer(Queue queue, Address address, Handler handler) {
        this(queue, (Ready)new DatagramReady(queue.getSelector(), queue.allocator()).bind(), address, handler);
    }

    public SnmpServer(Queue queue, Ready ready, Address address, final Handler handler) {
        this.queue = queue;
        new QueueReady(queue, ready).connect(address, new ReadyConnection(){

            private BerPacket ber(String s) {
                return new BytesBerPacket(BerPacketUtils.bytes(s));
            }

            public void handle(Address address, ByteBuffer buffer) {
                LinkedList<Pair<Oid, BerPacket>> next;
                Oid oid;
                int bulkLength;
                int requestId;
                int request;
                String community;
                try {
                    BerReader ber = new BerReader(buffer);
                    ber.beginReadSequence();
                    ber.readInteger();
                    community = BerPacketUtils.string(ber.readBytes());
                    request = ber.beginReadSequence();
                    requestId = ber.readInteger();
                    ber.readInteger();
                    bulkLength = ber.readInteger();
                    ber.beginReadSequence();
                    ber.beginReadSequence();
                    oid = ber.readOid();
                    ber.readNull();
                    ber.endReadSequence();
                    ber.endReadSequence();
                    ber.endReadSequence();
                    ber.endReadSequence();
                }
                catch (IOException e) {
                    LOGGER.error("Invalid packet", (Throwable)e);
                    return;
                }
                LOGGER.trace("Request with community: {} and oid: {}", (Object)community, (Object)oid);
                if (request == 160) {
                    next = new LinkedList<Pair<Oid, BerPacket>>();
                    handler.from(oid, new Handler.Callback(){

                        @Override
                        public boolean handle(Oid handleOid, String value) {
                            next.add(new Pair((Object)handleOid, (Object)this.ber(value)));
                            return false;
                        }
                    });
                    if (next.isEmpty()) {
                        LOGGER.trace("GET {}: None", (Object)oid);
                        this.write(address, this.build(requestId, community, 2, 0, null));
                        return;
                    }
                    LOGGER.trace("GET {}: {}", (Object)oid, next);
                    this.write(address, this.build(requestId, community, 0, 0, next));
                    return;
                }
                if (request == 161) {
                    next = new LinkedList();
                    handler.from(oid, new Handler.Callback(){

                        @Override
                        public boolean handle(Oid handleOid, String value) {
                            if (!handleOid.equals(oid)) {
                                next.add(new Pair((Object)handleOid, (Object)this.ber(value)));
                            }
                            return false;
                        }
                    });
                    if (next.isEmpty()) {
                        LOGGER.trace("GETNEXT {}: No next", (Object)oid);
                        this.write(address, this.build(requestId, community, 2, 0, null));
                        return;
                    }
                    LOGGER.trace("GETNEXT {}: {}", (Object)oid, next);
                    this.write(address, this.build(requestId, community, 0, 0, next));
                    return;
                }
                if (request == 165) {
                    next = new LinkedList();
                    handler.from(oid, new Handler.Callback(){

                        @Override
                        public boolean handle(Oid handleOid, String value) {
                            if (!handleOid.equals(oid)) {
                                next.add(new Pair((Object)handleOid, (Object)this.ber(value)));
                            }
                            return next.size() < bulkLength;
                        }
                    });
                    if (next.isEmpty()) {
                        LOGGER.trace("GETBULK {}: No next", (Object)oid);
                        this.write(address, this.build(requestId, community, 2, 0, null));
                        return;
                    }
                    LOGGER.trace("GETBULK {}: {}", (Object)oid, next);
                    this.write(address, this.build(requestId, community, 0, 0, next));
                    return;
                }
            }

            private void write(Address address, ByteBuffer b) {
                SnmpServer.this.write.handle(address, b);
            }

            private ByteBuffer build(int requestId, String community, int errorStatus, int errorIndex, Iterable<Pair<Oid, BerPacket>> oidValues) {
                SequenceBerPacket oidSequence = new SequenceBerPacket(48);
                if (oidValues != null) {
                    for (Pair<Oid, BerPacket> ov : oidValues) {
                        oidSequence.add(new SequenceBerPacket(48).add(new OidBerPacket((Oid)ov.first)).add((BerPacket)ov.second));
                    }
                }
                SequenceBerPacket root = new SequenceBerPacket(48).add(new IntegerBerPacket(1)).add(new BytesBerPacket(BerPacketUtils.bytes(community))).add(new SequenceBerPacket(162).add(new IntegerBerPacket(requestId)).add(new IntegerBerPacket(errorStatus)).add(new IntegerBerPacket(errorIndex)).add(oidSequence));
                ByteBuffer buffer = ByteBuffer.allocate(BerPacketUtils.typeAndLengthBufferLength(root.lengthBuffer()) + root.length());
                root.write(buffer);
                buffer.flip();
                return buffer;
            }

            public void failed(IOException e) {
                LOGGER.error("Failed", (Throwable)e);
            }

            public void connected(FailableCloseableByteBufferHandler write) {
                LOGGER.trace("Connected");
                if (SnmpServer.this.closed) {
                    write.close();
                } else {
                    SnmpServer.this.write = (CloseableByteBufferHandler)write;
                }
            }

            public void close() {
            }
        });
    }

    @Override
    public void close() {
        this.queue.post(new Runnable(){

            @Override
            public void run() {
                SnmpServer.this.closed = true;
                if (SnmpServer.this.write != null) {
                    SnmpServer.this.write.close();
                }
            }
        });
    }

    public static interface Handler {
        public void from(Oid var1, Callback var2);

        public static interface Callback {
            public boolean handle(Oid var1, String var2);
        }
    }
}

