/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.BerPacketUtils;
import com.davfx.ninio.snmp.BytesBerPacket;
import com.davfx.ninio.snmp.IntegerBerPacket;
import com.davfx.ninio.snmp.NullBerPacket;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.OidBerPacket;
import com.davfx.ninio.snmp.SequenceBerPacket;
import java.nio.ByteBuffer;

final class Version2cPacketBuilder {
    private final ByteBuffer buffer;

    private Version2cPacketBuilder(String community, int requestId, Oid oid, int type, int bulkLength) {
        SequenceBerPacket root = new SequenceBerPacket(48).add(new IntegerBerPacket(1)).add(new BytesBerPacket(BerPacketUtils.bytes(community))).add(new SequenceBerPacket(type).add(new IntegerBerPacket(requestId)).add(new IntegerBerPacket(0)).add(new IntegerBerPacket(bulkLength)).add(new SequenceBerPacket(48).add(new SequenceBerPacket(48).add(new OidBerPacket(oid)).add(new NullBerPacket()))));
        this.buffer = ByteBuffer.allocate(BerPacketUtils.typeAndLengthBufferLength(root.lengthBuffer()) + root.length());
        root.write(this.buffer);
        this.buffer.flip();
    }

    public static Version2cPacketBuilder getBulk(String community, int requestId, Oid oid, int bulkLength) {
        return new Version2cPacketBuilder(community, requestId, oid, 165, bulkLength);
    }

    public static Version2cPacketBuilder get(String community, int requestId, Oid oid) {
        return new Version2cPacketBuilder(community, requestId, oid, 160, 0);
    }

    public static Version2cPacketBuilder getNext(String community, int requestId, Oid oid) {
        return new Version2cPacketBuilder(community, requestId, oid, 161, 0);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

