/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.AuthRemoteEngine;
import com.davfx.ninio.snmp.BerPacketUtils;
import com.davfx.ninio.snmp.BerReader;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.Result;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Version3PacketParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(Version3PacketParser.class);
    private static final Oid AUTH_ERROR_OID = new Oid("1.3.6.1.6.3.15.1.1");
    private final int requestId;
    private final int errorStatus;
    private final int errorIndex;
    private final List<Result> results = new LinkedList<Result>();

    public Version3PacketParser(AuthRemoteEngine authEngine, ByteBuffer buffer) throws IOException {
        BerReader ber = new BerReader(buffer);
        ber.beginReadSequence();
        int version = ber.readInteger();
        if (version != 3) {
            throw new IOException("Invalid version: " + version + " should be " + 3);
        }
        ber.beginReadSequence();
        ber.readInteger();
        ber.readInteger();
        byte securityFlags = ber.readBytes().get();
        int securityModel = ber.readInteger();
        if (securityModel != 3) {
            throw new IOException("Invalid security model: " + securityModel + " should be " + 3);
        }
        ber.endReadSequence();
        BerReader secBer = new BerReader(ber.readBytes());
        secBer.beginReadSequence();
        ByteBuffer engine = secBer.readBytes();
        byte[] id = new byte[engine.remaining()];
        engine.get(id);
        authEngine.setId(id);
        authEngine.setBootCount(secBer.readInteger());
        authEngine.resetTime(secBer.readInteger());
        String login = BerPacketUtils.string(secBer.readBytes());
        if (!login.equals(authEngine.getAuthLogin())) {
            throw new IOException("Bad login: " + login + " should be: " + authEngine.getAuthLogin());
        }
        secBer.readBytes();
        ByteBuffer decryptParams = secBer.readBytes();
        if (decryptParams.hasRemaining()) {
            byte[] dp = new byte[decryptParams.remaining()];
            decryptParams.get(dp);
            authEngine.setEncryptionParameters(dp);
        }
        secBer.endReadSequence();
        BerReader pdu = (securityFlags & 2) != 0 ? new BerReader(authEngine.decrypt(ber.readBytes())) : ber;
        pdu.beginReadSequence();
        pdu.readBytes();
        pdu.readBytes();
        if (!authEngine.isReady()) {
            if (ber.beginReadSequence() != 168) {
                throw new IOException("Not a report packet");
            }
            this.requestId = pdu.readInteger();
            pdu.readInteger();
            pdu.readInteger();
            this.errorStatus = -1;
            this.errorIndex = 0;
            pdu.beginReadSequence();
            while (pdu.hasRemainingInSequence()) {
                pdu.beginReadSequence();
                pdu.readOid();
                pdu.readValue();
                pdu.endReadSequence();
            }
            pdu.endReadSequence();
            pdu.endReadSequence();
        } else {
            int s = pdu.beginReadSequence();
            if (s == 168) {
                this.requestId = pdu.readInteger();
                int errorStatus = pdu.readInteger();
                int errorIndex = pdu.readInteger();
                pdu.beginReadSequence();
                while (pdu.hasRemainingInSequence()) {
                    pdu.beginReadSequence();
                    Oid oid = pdu.readOid();
                    if (AUTH_ERROR_OID.isPrefix(oid)) {
                        LOGGER.error("Authentication failed ({}), requestId = {}", (Object)oid, (Object)this.requestId);
                        errorStatus = -2;
                        errorIndex = 0;
                    }
                    String value = pdu.readValue();
                    this.results.add(new Result(oid, value));
                    pdu.endReadSequence();
                }
                pdu.endReadSequence();
                this.errorStatus = errorStatus;
                this.errorIndex = errorIndex;
            } else {
                if (s != 162) {
                    throw new IOException("Not a response packet");
                }
                this.requestId = pdu.readInteger();
                this.errorStatus = pdu.readInteger();
                this.errorIndex = pdu.readInteger();
                pdu.beginReadSequence();
                while (pdu.hasRemainingInSequence()) {
                    pdu.beginReadSequence();
                    Oid oid = pdu.readOid();
                    String value = pdu.readValue();
                    this.results.add(new Result(oid, value));
                    pdu.endReadSequence();
                }
                pdu.endReadSequence();
            }
            pdu.endReadSequence();
        }
        pdu.endReadSequence();
        ber.endReadSequence();
        authEngine.setReady();
    }

    public Iterable<Result> getResults() {
        return this.results;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public int getErrorStatus() {
        return this.errorStatus;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }
}

