/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.Auth;
import com.davfx.ninio.snmp.EncryptionEngine;
import com.google.common.io.BaseEncoding;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AuthRemoteEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthRemoteEngine.class);
    private static final int INITIAL_PACKET_NUMBER = 61473655;
    private int bootCount;
    private int resetTime;
    private byte[] id;
    public final Auth auth;
    private int packetNumber;
    private byte[] encryptionParameters;
    private long timeResetAt;
    private int time;
    public final EncryptionEngine encryptionEngine;
    private byte[] authKey;
    private byte[] privKey;

    public AuthRemoteEngine(Auth auth, EncryptionEngine encryptionEngine) {
        this.auth = auth;
        this.encryptionEngine = encryptionEngine;
        this.reset();
    }

    public void reset() {
        this.bootCount = 0;
        this.resetTime = 0;
        this.id = null;
        this.packetNumber = 61473655;
        this.encryptionParameters = new byte[8];
        this.timeResetAt = 0L;
        this.time = 0;
        this.authKey = this.encryptionEngine.regenerateKey(null, this.auth.authPassword);
        this.privKey = this.encryptionEngine.regenerateKey(null, this.auth.privPassword);
    }

    public int incPacketNumber() {
        int n = this.packetNumber++;
        return n;
    }

    public byte[] getEncryptionParameters() {
        return this.encryptionParameters;
    }

    public boolean isValid() {
        return this.id != null && this.time > 0;
    }

    public byte[] getId() {
        return this.id;
    }

    public void setId(byte[] id) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Auth engine ID: {} -> {}", (Object)(this.id == null ? null : BaseEncoding.base16().encode(this.id)), (Object)BaseEncoding.base16().encode(id));
        }
        this.id = id;
        this.authKey = this.encryptionEngine.regenerateKey(this.id, this.auth.authPassword);
        this.privKey = this.encryptionEngine.regenerateKey(this.id, this.auth.privPassword);
    }

    public void setEncryptionParameters(byte[] encryptionParameters) {
        this.encryptionParameters = encryptionParameters;
    }

    public int getBootCount() {
        return this.bootCount;
    }

    public void setBootCount(int bootCount) {
        LOGGER.trace("Auth engine boot count: {} -> {}", (Object)this.bootCount, (Object)bootCount);
        this.bootCount = bootCount;
    }

    public int getTime() {
        return this.time;
    }

    public void renewTime() {
        if (this.timeResetAt > 0L) {
            int oldTime = this.time;
            this.time = this.resetTime + (int)((System.currentTimeMillis() - this.timeResetAt) / 1000L);
            LOGGER.trace("Auth engine time: ({}) {} -> {}", new Object[]{this.resetTime, oldTime, this.time});
        }
    }

    public void resetTime(int resetTime) {
        LOGGER.trace("Auth engine reset time: {} ({}) -> {}", new Object[]{this.resetTime, this.time, resetTime});
        if (resetTime == 0) {
            this.timeResetAt = 0L;
            this.time = 0;
            this.resetTime = 0;
        } else {
            this.timeResetAt = System.currentTimeMillis();
            this.resetTime = resetTime;
            this.time = resetTime;
        }
    }

    public byte[] hash(ByteBuffer message) {
        return this.encryptionEngine.hash(this.authKey, message);
    }

    public ByteBuffer encrypt(ByteBuffer decryptedBuffer) {
        return this.encryptionEngine.encrypt(this.getBootCount(), this.getTime(), this.encryptionParameters, this.privKey, decryptedBuffer);
    }

    public ByteBuffer decrypt(ByteBuffer encryptedBuffer) {
        return this.encryptionEngine.decrypt(this.getBootCount(), this.getTime(), this.encryptionParameters, this.privKey, encryptedBuffer);
    }
}

