/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;

public final class BerPacketUtils {
    private static final int MAX_LENGTH_BUFFER_SIZE = 10;

    private BerPacketUtils() {
    }

    public static void writeHeader(int type, ByteBuffer lengthBuffer, ByteBuffer buffer) {
        buffer.put((byte)type);
        int p = lengthBuffer.position();
        buffer.put(lengthBuffer);
        lengthBuffer.position(p);
    }

    public static int typeAndLengthBufferLength(ByteBuffer lengthBuffer) {
        return 1 + lengthBuffer.remaining();
    }

    public static ByteBuffer bytes(String s) {
        return ByteBuffer.wrap(s.getBytes(Charsets.US_ASCII));
    }

    public static String string(ByteBuffer bb) {
        ByteBuffer d = bb.duplicate();
        byte[] b = new byte[d.remaining()];
        d.get(b);
        return new String(b, Charsets.US_ASCII);
    }

    public static ByteBuffer lengthBuffer(int length) {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        if (length < 128) {
            buffer.put((byte)length);
        } else {
            int mask = 255;
            int bits = 0;
            int count = 0;
            while (true) {
                ++count;
                if ((length & (mask <<= 8)) == 0) break;
                bits += 8;
            }
            buffer.put((byte)(0x80 | count));
            while (bits >= 0) {
                int b = length >>> bits & 0xFF;
                buffer.put((byte)b);
                bits -= 8;
            }
        }
        buffer.flip();
        return buffer;
    }
}

