/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.util.MemoryCache;
import com.google.common.base.Charsets;
import com.google.common.io.BaseEncoding;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EncryptionEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptionEngine.class);
    private static final int ENCRYPTION_MARGIN = 64;
    private final SecureRandom random = new SecureRandom();
    private final MessageDigest messageDigest;
    private final Cipher cipher;
    private final int privKeyLength;
    private final MemoryCache<String, byte[]> cache;
    private final String privEncryptionAlgorithm;

    public EncryptionEngine(String authDigestAlgorithm, String privEncryptionAlgorithm, double cacheDuration) {
        if (authDigestAlgorithm == null) {
            this.messageDigest = null;
        } else {
            try {
                this.messageDigest = MessageDigest.getInstance(authDigestAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        if (privEncryptionAlgorithm == null) {
            this.privEncryptionAlgorithm = null;
            this.cipher = null;
            this.privKeyLength = 0;
        } else {
            this.privEncryptionAlgorithm = privEncryptionAlgorithm;
            LOGGER.trace("Creating encryption engine");
            try {
                this.cipher = Cipher.getInstance(String.valueOf(privEncryptionAlgorithm) + "/" + (privEncryptionAlgorithm.equals("AES") ? "CFB" : "CBC") + "/" + (privEncryptionAlgorithm.equals("AES") ? "NoPadding" : "PKCS5Padding"));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException(e);
            }
            LOGGER.trace("Encryption engine created");
            this.privKeyLength = privEncryptionAlgorithm.equals("AES") ? 16 : 8;
        }
        this.cache = MemoryCache.builder().expireAfterAccess(cacheDuration).build();
    }

    public byte[] regenerateKey(byte[] id, String password) {
        if (this.messageDigest == null) {
            return null;
        }
        if (password == null) {
            return null;
        }
        if (id == null) {
            return null;
        }
        String k = String.valueOf(BaseEncoding.base64().encode(id)) + " " + password;
        byte[] d = (byte[])this.cache.get((Object)k);
        if (d == null) {
            LOGGER.trace("Regenerating key");
            byte[] passwordBytes = password.getBytes(Charsets.UTF_8);
            int count = 0;
            int s = 0x100000;
            while (count < s) {
                int l = passwordBytes.length;
                if (count + l > s) {
                    l = s - count;
                }
                this.messageDigest.update(passwordBytes, 0, l);
                count += l;
            }
            byte[] digest = this.messageDigest.digest();
            this.messageDigest.reset();
            this.messageDigest.update(digest);
            this.messageDigest.update(id);
            this.messageDigest.update(digest);
            d = this.messageDigest.digest();
            this.cache.put((Object)k, (Object)d);
            LOGGER.trace("Key regenerated");
        }
        return d;
    }

    public byte[] hash(byte[] authKey, ByteBuffer message) {
        if (this.messageDigest == null) {
            return null;
        }
        ByteBuffer messageDup = message.duplicate();
        byte[] k_ipad = new byte[64];
        byte[] k_opad = new byte[64];
        int i = 0;
        while (i < authKey.length) {
            k_ipad[i] = (byte)(authKey[i] ^ 0x36);
            k_opad[i] = (byte)(authKey[i] ^ 0x5C);
            ++i;
        }
        i = authKey.length;
        while (i < 64) {
            k_ipad[i] = 54;
            k_opad[i] = 92;
            ++i;
        }
        this.messageDigest.reset();
        this.messageDigest.update(k_ipad);
        this.messageDigest.update(messageDup);
        byte[] newDigest = this.messageDigest.digest();
        this.messageDigest.reset();
        this.messageDigest.update(k_opad);
        this.messageDigest.update(newDigest);
        newDigest = this.messageDigest.digest();
        byte[] k = new byte[12];
        System.arraycopy(newDigest, 0, k, 0, k.length);
        return k;
    }

    public ByteBuffer encrypt(int bootCount, int time, byte[] encryptionParameters, byte[] privKey, ByteBuffer decryptedBuffer) {
        byte[] iv;
        if (this.cipher == null) {
            return null;
        }
        int salt = this.random.nextInt();
        if (this.privEncryptionAlgorithm.equals("AES")) {
            iv = new byte[16];
            ByteBuffer ivb = ByteBuffer.wrap(iv);
            ivb.putInt(bootCount);
            ivb.putInt(time);
            ivb.putInt(0);
            ivb.putInt(salt);
            ByteBuffer bb = ByteBuffer.wrap(encryptionParameters);
            bb.putInt(0);
            bb.putInt(salt);
        } else {
            ByteBuffer bb = ByteBuffer.wrap(encryptionParameters);
            bb.putInt(bootCount);
            bb.putInt(salt);
            iv = new byte[8];
            int i = 0;
            while (i < iv.length) {
                iv[i] = (byte)(privKey[iv.length + i] ^ encryptionParameters[i]);
                ++i;
            }
        }
        try {
            this.cipher.init(1, (Key)new SecretKeySpec(privKey, 0, this.privKeyLength, this.privEncryptionAlgorithm), new IvParameterSpec(iv));
            ByteBuffer b = ByteBuffer.allocate(decryptedBuffer.remaining() + 64);
            this.cipher.doFinal(decryptedBuffer, b);
            b.flip();
            return b;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteBuffer decrypt(int bootCount, int time, byte[] encryptionParameters, byte[] privKey, ByteBuffer encryptedBuffer) {
        byte[] iv;
        if (this.cipher == null) {
            return null;
        }
        if (this.privEncryptionAlgorithm.equals("AES")) {
            iv = new byte[16];
            ByteBuffer ivb = ByteBuffer.wrap(iv);
            ivb.putInt(bootCount);
            ivb.putInt(time);
            ByteBuffer bb = ByteBuffer.wrap(encryptionParameters);
            ivb.putInt(bb.getInt());
            ivb.putInt(bb.getInt());
        } else {
            iv = new byte[8];
            int i = 0;
            while (i < 8) {
                iv[i] = (byte)(privKey[8 + i] ^ encryptionParameters[i]);
                ++i;
            }
        }
        try {
            SecretKeySpec key = new SecretKeySpec(privKey, 0, this.privKeyLength, this.privEncryptionAlgorithm);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            this.cipher.init(2, (Key)key, ivSpec);
            ByteBuffer b = ByteBuffer.allocate(encryptedBuffer.remaining() + 64);
            this.cipher.doFinal(encryptedBuffer, b);
            b.flip();
            return b;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

