/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Connecter;
import com.davfx.ninio.core.Ninio;
import com.davfx.ninio.core.NinioBuilder;
import com.davfx.ninio.core.UdpSocket;
import com.davfx.ninio.snmp.AuthRemoteSpecification;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.SnmpCallType;
import com.davfx.ninio.snmp.SnmpClient;
import com.davfx.ninio.snmp.SnmpConnecter;
import com.davfx.ninio.snmp.SnmpConnection;
import com.davfx.ninio.snmp.SnmpReceiver;
import com.davfx.ninio.snmp.SnmpRequestBuilder;
import com.davfx.ninio.snmp.SnmpResult;
import com.davfx.ninio.util.Wait;
import java.io.IOException;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) throws Exception {
        LOGGER.trace("TRACE");
        String community = System.getProperty("community");
        System.out.println("community = " + community);
        String login = System.getProperty("login", "snmp-poller");
        System.out.println("login = " + login);
        String authPassword = System.getProperty("authPassword", "PASSWORD1");
        System.out.println("authPassword = " + authPassword);
        String privPassword = System.getProperty("privPassword", "PASSWORD1");
        System.out.println("privPassword = " + privPassword);
        String authMethod = System.getProperty("authMethod", "SHA");
        System.out.println("authMethod = " + authMethod);
        String privMethod = System.getProperty("privMethod", "AES");
        System.out.println("privMethod = " + privMethod);
        String contextName = System.getProperty("contextName", null);
        System.out.println("contextName = " + contextName);
        byte[] ip = InetAddress.getByName(System.getProperty("ip", "10.3.101.6")).getAddress();
        String portProperty = System.getProperty("port");
        int port = portProperty == null ? 161 : Integer.parseInt(portProperty);
        Oid oid = new Oid(System.getProperty("oid", "1.3.6.1.2.1.2.2.1.2"));
        System.out.println("ip = " + Address.ipToString((byte[])ip));
        System.out.println("port = " + port);
        System.out.println("oid = " + oid);
        Throwable throwable = null;
        Object var13_14 = null;
        try (Ninio ninio = Ninio.create();){
            final Wait waitClient = new Wait();
            Throwable throwable2 = null;
            Object var17_20 = null;
            try (SnmpConnecter snmpClient = (SnmpConnecter)ninio.create((NinioBuilder)SnmpClient.builder().with((NinioBuilder<Connecter>)UdpSocket.builder()));){
                snmpClient.connect(new SnmpConnection(){

                    public void failed(IOException ioe) {
                    }

                    public void connected(Address address) {
                    }

                    public void closed() {
                        waitClient.run();
                    }
                });
                SnmpRequestBuilder r = snmpClient.request();
                if (community == null) {
                    r.auth(new AuthRemoteSpecification(login, authPassword, authMethod, privPassword, privMethod, contextName));
                } else {
                    r.community(community);
                }
                r.build(new Address(ip, port), oid).call(SnmpCallType.GET, new SnmpReceiver(){

                    @Override
                    public void received(SnmpResult result) {
                        System.out.println(result);
                    }

                    @Override
                    public void finished() {
                        System.out.println("---FINISHED---");
                        waitClient.run();
                    }

                    public void failed(IOException ioe) {
                        ioe.printStackTrace();
                    }
                });
                waitClient.waitFor();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

