/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.BerPacket;
import com.davfx.ninio.snmp.BerPacketUtils;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public final class SequenceBerPacket
implements BerPacket {
    private final List<BerPacket> toWrite = new LinkedList<BerPacket>();
    private final int type;

    public SequenceBerPacket(int type) {
        this.type = type;
    }

    @Override
    public int length() {
        int l = 0;
        for (BerPacket p : this.toWrite) {
            l += BerPacketUtils.typeAndLengthBufferLength(p.lengthBuffer()) + p.length();
        }
        return l;
    }

    @Override
    public ByteBuffer lengthBuffer() {
        return BerPacketUtils.lengthBuffer(this.length());
    }

    @Override
    public void write(ByteBuffer buffer) {
        BerPacketUtils.writeHeader(this.type, this.lengthBuffer(), buffer);
        for (BerPacket p : this.toWrite) {
            p.write(buffer);
        }
    }

    public SequenceBerPacket add(BerPacket sequence) {
        this.toWrite.add(sequence);
        return this;
    }
}

