/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Connecter;
import com.davfx.ninio.core.Connection;
import com.davfx.ninio.core.NinioBuilder;
import com.davfx.ninio.core.NinioProvider;
import com.davfx.ninio.core.SendCallback;
import com.davfx.ninio.core.UdpSocket;
import com.davfx.ninio.snmp.Auth;
import com.davfx.ninio.snmp.AuthRemoteEngine;
import com.davfx.ninio.snmp.AuthRemoteSpecification;
import com.davfx.ninio.snmp.Cancelable;
import com.davfx.ninio.snmp.EncryptionEngine;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.SnmpCallType;
import com.davfx.ninio.snmp.SnmpConnecter;
import com.davfx.ninio.snmp.SnmpConnection;
import com.davfx.ninio.snmp.SnmpPacketParser;
import com.davfx.ninio.snmp.SnmpReceiver;
import com.davfx.ninio.snmp.SnmpRequestBuilder;
import com.davfx.ninio.snmp.SnmpResult;
import com.davfx.ninio.snmp.Version2cPacketBuilder;
import com.davfx.ninio.snmp.Version3PacketBuilder;
import com.davfx.ninio.snmp.dependencies.Dependencies;
import com.davfx.ninio.util.ConfigUtils;
import com.davfx.ninio.util.MemoryCache;
import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnmpClient
implements SnmpConnecter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnmpClient.class);
    private static final Config CONFIG = ConfigUtils.load((com.davfx.ninio.util.Dependencies)new Dependencies()).getConfig(SnmpClient.class.getPackage().getName());
    public static final int DEFAULT_PORT = 161;
    public static final int DEFAULT_TRAP_PORT = 162;
    private static final int BULK_SIZE = CONFIG.getInt("bulkSize");
    private static final double AUTH_ENGINES_CACHE_DURATION = ConfigUtils.getDuration((Config)CONFIG, (String)"auth.cache");
    private final Executor executor;
    private final Connecter connecter;
    private final InstanceMapper instanceMapper;
    private final RequestIdProvider requestIdProvider = new RequestIdProvider();
    private final MemoryCache<Address, Auth> auths = MemoryCache.builder().expireAfterAccess(AUTH_ENGINES_CACHE_DURATION).build();
    private final MemoryCache<AuthRemoteEngineKey, AuthRemoteEnginePendingRequestManager> authRemoteEngines = MemoryCache.builder().expireAfterAccess(AUTH_ENGINES_CACHE_DURATION).build();
    private final MemoryCache<EncryptionEngineKey, EncryptionEngine> encryptionEngines = MemoryCache.builder().expireAfterAccess(AUTH_ENGINES_CACHE_DURATION).build();

    public static Builder builder() {
        return new Builder(){
            private NinioBuilder<Connecter> connecterFactory = UdpSocket.builder();

            @Override
            @Deprecated
            public Builder with(Executor executor) {
                return this;
            }

            @Override
            public Builder with(NinioBuilder<Connecter> connecterFactory) {
                this.connecterFactory = connecterFactory;
                return this;
            }

            public SnmpConnecter create(NinioProvider ninioProvider) {
                return new SnmpClient(ninioProvider.executor(), (Connecter)this.connecterFactory.create(ninioProvider), null);
            }
        };
    }

    private SnmpClient(Executor executor, Connecter connecter) {
        this.executor = executor;
        this.connecter = connecter;
        this.instanceMapper = new InstanceMapper(this.requestIdProvider);
    }

    @Override
    public SnmpRequestBuilder request() {
        return new SnmpRequestBuilder(){
            private String community = null;
            private AuthRemoteSpecification authRemoteSpecification = null;
            private Address address;
            private Oid oid;
            private List<SnmpResult> trap = null;
            private Instance instance = null;

            @Override
            public SnmpRequestBuilder community(String community) {
                this.community = community;
                return this;
            }

            @Override
            public SnmpRequestBuilder auth(AuthRemoteSpecification authRemoteSpecification) {
                this.authRemoteSpecification = authRemoteSpecification;
                return this;
            }

            @Override
            public SnmpRequestBuilder build(Address address, Oid oid) {
                this.address = address;
                this.oid = oid;
                return this;
            }

            @Override
            public void cancel() {
                SnmpClient.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (instance != null) {
                            instance.cancel();
                        }
                    }
                });
            }

            @Override
            public SnmpRequestBuilder add(Oid oid, String value) {
                if (this.trap == null) {
                    this.trap = new LinkedList<SnmpResult>();
                }
                this.trap.add(new SnmpResult(oid, value));
                return this;
            }

            @Override
            public Cancelable call(final SnmpCallType type, SnmpReceiver r) {
                Auth auth = this.authRemoteSpecification == null ? null : new Auth(this.authRemoteSpecification.login, this.authRemoteSpecification.authPassword, this.authRemoteSpecification.authDigestAlgorithm, this.authRemoteSpecification.privPassword, this.authRemoteSpecification.privEncryptionAlgorithm);
                final String contextName = this.authRemoteSpecification == null ? null : this.authRemoteSpecification.contextName;
                final Oid o = this.oid;
                final Address a = this.address;
                final String c = this.community;
                ImmutableList t = this.trap == null ? null : ImmutableList.copyOf(this.trap);
                SnmpClient.this.executor.execute(new Runnable((Iterable)t, auth, r){
                    private final /* synthetic */ Iterable val$t;
                    private final /* synthetic */ Auth val$auth;
                    private final /* synthetic */ SnmpReceiver val$r;
                    {
                        this.val$t = iterable;
                        this.val$auth = auth;
                        this.val$r = snmpReceiver;
                    }

                    @Override
                    public void run() {
                        if (instance != null) {
                            throw new IllegalStateException();
                        }
                        instance = new Instance(SnmpClient.this.connecter, SnmpClient.this.instanceMapper, o, contextName, a, type, c, this.val$t);
                        AuthRemoteEnginePendingRequestManager authRemoteEnginePendingRequestManager = null;
                        if (this.val$auth != null) {
                            Auth previousAuth = (Auth)SnmpClient.this.auths.get((Object)a);
                            if (previousAuth != null && !previousAuth.equals(this.val$auth)) {
                                LOGGER.debug("Auth changed ({} -> {}) for {}", new Object[]{previousAuth, this.val$auth, a});
                            }
                            SnmpClient.this.auths.put((Object)a, (Object)this.val$auth);
                            EncryptionEngineKey encryptionEngineKey = new EncryptionEngineKey(this.val$auth.authDigestAlgorithm, this.val$auth.privEncryptionAlgorithm);
                            EncryptionEngine encryptionEngine = (EncryptionEngine)SnmpClient.this.encryptionEngines.get((Object)encryptionEngineKey);
                            if (encryptionEngine == null) {
                                encryptionEngine = new EncryptionEngine(this.val$auth.authDigestAlgorithm, this.val$auth.privEncryptionAlgorithm, AUTH_ENGINES_CACHE_DURATION);
                                SnmpClient.this.encryptionEngines.put((Object)encryptionEngineKey, (Object)encryptionEngine);
                            }
                            AuthRemoteEngineKey authRemoteEngineKey = new AuthRemoteEngineKey(a, this.val$auth);
                            authRemoteEnginePendingRequestManager = (AuthRemoteEnginePendingRequestManager)SnmpClient.this.authRemoteEngines.get((Object)authRemoteEngineKey);
                            if (authRemoteEnginePendingRequestManager == null) {
                                authRemoteEnginePendingRequestManager = new AuthRemoteEnginePendingRequestManager(this.val$auth, encryptionEngine);
                                SnmpClient.this.authRemoteEngines.put((Object)authRemoteEngineKey, (Object)authRemoteEnginePendingRequestManager);
                                authRemoteEnginePendingRequestManager.discoverIfNecessary(a, SnmpClient.this.connecter);
                            }
                        }
                        instance.receiver = this.val$r;
                        instance.authRemoteEnginePendingRequestManager = authRemoteEnginePendingRequestManager;
                        instance.launch();
                    }
                });
                return new Cancelable(){

                    @Override
                    public void cancel() {
                        SnmpClient.this.executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                if (instance != null) {
                                    instance.cancel();
                                }
                            }
                        });
                    }
                };
            }
        };
    }

    @Override
    public void connect(final SnmpConnection callback) {
        this.connecter.connect(new Connection(){

            public void received(final Address address, final ByteBuffer buffer) {
                SnmpClient.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Iterable<SnmpResult> results;
                        int errorIndex;
                        int errorStatus;
                        int instanceId;
                        AuthRemoteEnginePendingRequestManager authRemoteEnginePendingRequestManager;
                        LOGGER.trace("Received SNMP packet, size = {}", (Object)buffer.remaining());
                        Auth auth = (Auth)SnmpClient.this.auths.get((Object)address);
                        if (auth == null) {
                            authRemoteEnginePendingRequestManager = null;
                        } else {
                            AuthRemoteEngineKey authRemoteEngineKey = new AuthRemoteEngineKey(address, auth);
                            authRemoteEnginePendingRequestManager = (AuthRemoteEnginePendingRequestManager)SnmpClient.this.authRemoteEngines.get((Object)authRemoteEngineKey);
                        }
                        boolean ready = authRemoteEnginePendingRequestManager != null ? authRemoteEnginePendingRequestManager.isReady() : true;
                        try {
                            SnmpPacketParser parser = new SnmpPacketParser(authRemoteEnginePendingRequestManager == null ? null : authRemoteEnginePendingRequestManager.engine, buffer);
                            instanceId = parser.getRequestId();
                            errorStatus = parser.getErrorStatus();
                            errorIndex = parser.getErrorIndex();
                            results = parser.getResults();
                        }
                        catch (Exception e) {
                            LOGGER.error("Invalid packet", (Throwable)e);
                            return;
                        }
                        if (authRemoteEnginePendingRequestManager != null) {
                            if (ready && errorStatus == -1) {
                                authRemoteEnginePendingRequestManager.reset();
                            }
                            authRemoteEnginePendingRequestManager.discoverIfNecessary(address, SnmpClient.this.connecter);
                            authRemoteEnginePendingRequestManager.sendPendingRequestsIfReady(address, SnmpClient.this.connecter);
                        }
                        SnmpClient.this.instanceMapper.handle(instanceId, errorStatus, errorIndex, results);
                    }
                });
            }

            public void failed(final IOException ioe) {
                SnmpClient.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        SnmpClient.this.instanceMapper.fail(ioe);
                    }
                });
                if (callback != null) {
                    callback.failed(ioe);
                }
            }

            public void connected(Address address) {
                if (callback != null) {
                    callback.connected(address);
                }
            }

            public void closed() {
                SnmpClient.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        SnmpClient.this.instanceMapper.fail(new IOException("Closed"));
                    }
                });
                if (callback != null) {
                    callback.closed();
                }
            }
        });
    }

    public void close() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                SnmpClient.this.instanceMapper.close();
            }
        });
        this.connecter.close();
    }

    /* synthetic */ SnmpClient(Executor executor, Connecter connecter, SnmpClient snmpClient) {
        this(executor, connecter);
    }

    private static final class AuthRemoteEngineKey {
        public final Address address;
        public final Auth auth;

        public AuthRemoteEngineKey(Address address, Auth auth) {
            this.address = address;
            this.auth = auth;
        }

        public int hashCode() {
            return Objects.hash(this.address, this.auth);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AuthRemoteEngineKey)) {
                return false;
            }
            AuthRemoteEngineKey other = (AuthRemoteEngineKey)obj;
            return Objects.equals(this.address, other.address) && Objects.equals(this.auth, other.auth);
        }
    }

    private static final class AuthRemoteEnginePendingRequestManager {
        public final AuthRemoteEngine engine;
        public final List<PendingRequest> pendingRequests = new LinkedList<PendingRequest>();

        public AuthRemoteEnginePendingRequestManager(Auth auth, EncryptionEngine encryptionEngine) {
            this.engine = new AuthRemoteEngine(auth, encryptionEngine);
        }

        public boolean isReady() {
            return this.engine.isValid();
        }

        public void reset() {
            this.engine.reset();
        }

        public void discoverIfNecessary(Address address, Connecter connector) {
            if (!this.engine.isValid()) {
                Version3PacketBuilder builder = Version3PacketBuilder.get(this.engine, null, 2043088696, null);
                ByteBuffer b = builder.getBuffer();
                LOGGER.trace("Writing discover GET v3: #{}, packet size = {}", (Object)2043088696, (Object)b.remaining());
                connector.send(address, b, new SendCallback(){

                    public void sent() {
                    }

                    public void failed(IOException ioe) {
                        IOException e = new IOException("Failed to send discover packet", ioe);
                        for (PendingRequest r : AuthRemoteEnginePendingRequestManager.this.pendingRequests) {
                            r.sendCallback.failed(e);
                        }
                        AuthRemoteEnginePendingRequestManager.this.pendingRequests.clear();
                    }
                });
            }
        }

        public void registerPendingRequest(PendingRequest r) {
            this.pendingRequests.add(r);
        }

        public void clearPendingRequests() {
            this.pendingRequests.clear();
        }

        public void sendPendingRequestsIfReady(Address address, Connecter connector) {
            if (!this.engine.isValid()) {
                return;
            }
            for (PendingRequest r : this.pendingRequests) {
                switch (r.request) {
                    case GET: {
                        Version3PacketBuilder builder = Version3PacketBuilder.get(this.engine, r.contextName, r.instanceId, r.oid);
                        ByteBuffer b = builder.getBuffer();
                        LOGGER.trace("Writing GET v3: {} #{}, packet size = {}", new Object[]{r.oid, r.instanceId, b.remaining()});
                        connector.send(address, b, r.sendCallback);
                        break;
                    }
                    case GETNEXT: {
                        Version3PacketBuilder builder = Version3PacketBuilder.getNext(this.engine, r.contextName, r.instanceId, r.oid);
                        ByteBuffer b = builder.getBuffer();
                        LOGGER.trace("Writing GETNEXT v3: {} #{}, packet size = {}", new Object[]{r.oid, r.instanceId, b.remaining()});
                        connector.send(address, b, r.sendCallback);
                        break;
                    }
                    case GETBULK: {
                        Version3PacketBuilder builder = Version3PacketBuilder.getBulk(this.engine, r.contextName, r.instanceId, r.oid, BULK_SIZE);
                        ByteBuffer b = builder.getBuffer();
                        LOGGER.trace("Writing GETBULK v3: {} #{}, packet size = {}", new Object[]{r.oid, r.instanceId, b.remaining()});
                        connector.send(address, b, r.sendCallback);
                        break;
                    }
                    case TRAP: {
                        LOGGER.error("No TRAP possible in v3: {} #{}", (Object)r.oid, (Object)r.instanceId);
                        break;
                    }
                }
            }
            this.pendingRequests.clear();
        }

        public static final class PendingRequest {
            public final SnmpCallType request;
            public final int instanceId;
            public final Oid oid;
            public final String contextName;
            public final SendCallback sendCallback;

            public PendingRequest(SnmpCallType request, int instanceId, Oid oid, String contextName, SendCallback sendCallback) {
                this.request = request;
                this.instanceId = instanceId;
                this.oid = oid;
                this.contextName = contextName;
                this.sendCallback = sendCallback;
            }
        }
    }

    public static interface Builder
    extends NinioBuilder<SnmpConnecter> {
        @Deprecated
        public Builder with(Executor var1);

        public Builder with(NinioBuilder<Connecter> var1);
    }

    private static final class EncryptionEngineKey {
        public final String authDigestAlgorithm;
        public final String privEncryptionAlgorithm;

        public EncryptionEngineKey(String authDigestAlgorithm, String privEncryptionAlgorithm) {
            this.authDigestAlgorithm = authDigestAlgorithm;
            this.privEncryptionAlgorithm = privEncryptionAlgorithm;
        }

        public int hashCode() {
            return Objects.hash(this.authDigestAlgorithm, this.privEncryptionAlgorithm);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof EncryptionEngineKey)) {
                return false;
            }
            EncryptionEngineKey other = (EncryptionEngineKey)obj;
            return Objects.equals(this.authDigestAlgorithm, other.authDigestAlgorithm) && Objects.equals(this.privEncryptionAlgorithm, other.privEncryptionAlgorithm);
        }
    }

    private static final class Instance {
        private final Connecter connector;
        private final InstanceMapper instanceMapper;
        private SnmpReceiver receiver;
        private final Oid requestOid;
        private final String requestContextName;
        public int instanceId = 2043088696;
        private final Address address;
        private final String community;
        private final SnmpCallType snmpCallType;
        private AuthRemoteEnginePendingRequestManager authRemoteEnginePendingRequestManager = null;
        private final Iterable<SnmpResult> trap;

        public Instance(Connecter connector, InstanceMapper instanceMapper, Oid requestOid, String requestContextName, Address address, SnmpCallType snmpCallType, String community, Iterable<SnmpResult> trap) {
            this.connector = connector;
            this.instanceMapper = instanceMapper;
            this.requestOid = requestOid;
            this.requestContextName = requestContextName;
            this.address = address;
            this.snmpCallType = snmpCallType;
            this.community = community;
            this.trap = trap;
        }

        public void launch() {
            if (this.receiver != null) {
                this.instanceMapper.map(this);
            }
            this.write();
        }

        public void close() {
            this.receiver = null;
        }

        public void cancel() {
            if (this.authRemoteEnginePendingRequestManager != null) {
                this.authRemoteEnginePendingRequestManager.clearPendingRequests();
            }
            this.instanceMapper.unmap(this);
            this.receiver = null;
        }

        private void write() {
            SendCallback sendCallback = new SendCallback(){

                public void sent() {
                }

                public void failed(IOException ioe) {
                    Instance.this.fail(ioe);
                }
            };
            if (this.authRemoteEnginePendingRequestManager == null) {
                switch (this.snmpCallType) {
                    case GET: {
                        Version2cPacketBuilder builder = Version2cPacketBuilder.get(this.community, this.instanceId, this.requestOid);
                        ByteBuffer b = builder.getBuffer();
                        LOGGER.trace("Writing GET: {} #{} ({}), packet size = {}", new Object[]{this.requestOid, this.instanceId, this.community, b.remaining()});
                        this.connector.send(this.address, b, sendCallback);
                        break;
                    }
                    case GETNEXT: {
                        Version2cPacketBuilder builder = Version2cPacketBuilder.getNext(this.community, this.instanceId, this.requestOid);
                        ByteBuffer b = builder.getBuffer();
                        LOGGER.trace("Writing GETNEXT: {} #{} ({}), packet size = {}", new Object[]{this.requestOid, this.instanceId, this.community, b.remaining()});
                        this.connector.send(this.address, b, sendCallback);
                        break;
                    }
                    case GETBULK: {
                        Version2cPacketBuilder builder = Version2cPacketBuilder.getBulk(this.community, this.instanceId, this.requestOid, BULK_SIZE);
                        ByteBuffer b = builder.getBuffer();
                        LOGGER.trace("Writing GETBULK: {} #{} ({}), packet size = {}", new Object[]{this.requestOid, this.instanceId, this.community, b.remaining()});
                        this.connector.send(this.address, b, sendCallback);
                        break;
                    }
                    case TRAP: {
                        Version2cPacketBuilder builder = Version2cPacketBuilder.trap(this.community, this.instanceId, this.requestOid, this.trap);
                        ByteBuffer b = builder.getBuffer();
                        LOGGER.trace("Writing TRAP: {} #{} ({}), packet size = {}", new Object[]{this.requestOid, this.instanceId, this.community, b.remaining()});
                        this.connector.send(this.address, b, sendCallback);
                        break;
                    }
                }
            } else {
                this.authRemoteEnginePendingRequestManager.registerPendingRequest(new AuthRemoteEnginePendingRequestManager.PendingRequest(this.snmpCallType, this.instanceId, this.requestOid, this.requestContextName, sendCallback));
                this.authRemoteEnginePendingRequestManager.sendPendingRequestsIfReady(this.address, this.connector);
            }
        }

        public void fail(IOException e) {
            if (this.receiver != null) {
                this.receiver.failed(e);
            }
            this.receiver = null;
        }

        private void handle(int errorStatus, int errorIndex, Iterable<SnmpResult> results) {
            if (this.requestOid == null) {
                return;
            }
            if (errorStatus == -1) {
                this.fail(new IOException("Authentication engine not synced"));
                return;
            }
            if (errorStatus == -2) {
                this.fail(new IOException("Authentication failed"));
                return;
            }
            if (errorStatus == -3) {
                this.fail(new IOException("Timeout"));
                return;
            }
            if (errorStatus != 0) {
                LOGGER.trace("Received error: {}/{}", (Object)errorStatus, (Object)errorIndex);
            }
            for (SnmpResult r : results) {
                if (r.value == null) continue;
                LOGGER.trace("Addind to results: {}", (Object)r);
                if (this.receiver == null) continue;
                this.receiver.received(r);
            }
            if (this.receiver != null) {
                this.receiver.finished();
            }
            this.receiver = null;
        }
    }

    private static final class InstanceMapper {
        private final RequestIdProvider requestIdProvider;
        private final Map<Integer, Instance> instances = new HashMap<Integer, Instance>();

        public InstanceMapper(RequestIdProvider requestIdProvider) {
            this.requestIdProvider = requestIdProvider;
        }

        public void map(Instance instance) {
            this.instances.remove(instance.instanceId);
            int instanceId = this.requestIdProvider.get();
            if (this.instances.containsKey(instanceId)) {
                LOGGER.warn("The maximum number of simultaneous request has been reached");
                return;
            }
            this.instances.put(instanceId, instance);
            LOGGER.trace("New instance ID = {}", (Object)instanceId);
            instance.instanceId = instanceId;
        }

        public void unmap(Instance instance) {
            this.instances.remove(instance.instanceId);
            instance.instanceId = 2043088696;
        }

        public void close() {
            for (Instance i : this.instances.values()) {
                i.close();
            }
            this.instances.clear();
        }

        public void fail(IOException ioe) {
            for (Instance i : this.instances.values()) {
                i.fail(ioe);
            }
            this.instances.clear();
        }

        public void handle(int instanceId, int errorStatus, int errorIndex, Iterable<SnmpResult> results) {
            if (instanceId == Integer.MAX_VALUE) {
                LOGGER.trace("Calling all instances (request ID = {})", (Object)Integer.MAX_VALUE);
                LinkedList<Instance> l = new LinkedList<Instance>(this.instances.values());
                this.instances.clear();
                for (Instance i : l) {
                    i.handle(errorStatus, errorIndex, results);
                }
                return;
            }
            Instance i = this.instances.remove(instanceId);
            if (i == null) {
                return;
            }
            i.handle(errorStatus, errorIndex, results);
        }
    }

    private static final class RequestIdProvider {
        private static final Random RANDOM = new SecureRandom();
        private static final int MIN_ID = 1000;
        private static final int MAX_ID = 2043088696;
        public static final int IGNORE_ID = 2043088696;
        private static int NEXT = 2043088696;
        private static final Object LOCK = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int get() {
            Object object = LOCK;
            synchronized (object) {
                if (NEXT == 2043088696) {
                    NEXT = 1000 + RANDOM.nextInt(2043087696);
                }
                int k = NEXT++;
                return k;
            }
        }
    }
}

