/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.core.InMemoryCache;
import com.davfx.ninio.snmp.BerPacketUtils;
import com.davfx.ninio.snmp.BerReader;
import com.davfx.ninio.snmp.BytesBerPacket;
import com.davfx.ninio.snmp.IntegerBerPacket;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.OidBerPacket;
import com.davfx.ninio.snmp.SequenceBerPacket;
import com.davfx.ninio.snmp.SnmpResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnmpInMemoryCacheInterpreter
implements InMemoryCache.Interpreter<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnmpInMemoryCacheInterpreter.class);

    public InMemoryCache.Context<Integer> handleRequest(ByteBuffer packet) {
        BerReader ber;
        block8: {
            block9: {
                block11: {
                    byte securityFlags;
                    block10: {
                        ber = new BerReader(packet);
                        ber.beginReadSequence();
                        int version = ber.readInteger();
                        if (version == 1) {
                            ber.readBytes();
                            int type = ber.beginReadSequence();
                            int requestId = ber.readInteger();
                            ber.readInteger();
                            ber.readInteger();
                            ber.beginReadSequence();
                            if (ber.hasRemainingInSequence()) {
                                ber.beginReadSequence();
                                Oid oid = ber.readOid();
                                ber.readValue();
                                String key = oid + "/" + type;
                                return new InMemoryCache.Context(key, (Object)requestId);
                            }
                            ber.endReadSequence();
                            ber.endReadSequence();
                            break block8;
                        }
                        if (version != 3) break block9;
                        ber.beginReadSequence();
                        ber.readInteger();
                        ber.readInteger();
                        securityFlags = ber.readBytes().get();
                        int securityModel = ber.readInteger();
                        if (securityModel == 3) break block10;
                        return null;
                    }
                    ber.endReadSequence();
                    BerReader secBer = new BerReader(ber.readBytes());
                    secBer.beginReadSequence();
                    secBer.readBytes();
                    secBer.readInteger();
                    secBer.readInteger();
                    secBer.readBytes();
                    secBer.readBytes();
                    secBer.readBytes();
                    secBer.endReadSequence();
                    if ((securityFlags & 2) == 0) break block11;
                    return null;
                }
                BerReader pdu = ber;
                pdu.beginReadSequence();
                pdu.readBytes();
                String contextName = BerPacketUtils.string(pdu.readBytes());
                int type = pdu.beginReadSequence();
                int requestId = pdu.readInteger();
                pdu.readInteger();
                pdu.readInteger();
                pdu.beginReadSequence();
                if (pdu.hasRemainingInSequence()) {
                    pdu.beginReadSequence();
                    Oid oid = pdu.readOid();
                    pdu.readValue();
                    String key = oid + "/" + type + "/" + contextName;
                    return new InMemoryCache.Context(key, (Object)requestId);
                }
                pdu.endReadSequence();
                pdu.endReadSequence();
                break block8;
            }
            return null;
        }
        try {
            ber.endReadSequence();
        }
        catch (IOException ioe) {
            LOGGER.error("Invalid request packet", (Throwable)ioe);
        }
        return null;
    }

    public Integer handleResponse(ByteBuffer packet) {
        block5: {
            BerReader ber;
            block6: {
                try {
                    ber = new BerReader(packet);
                    ber.beginReadSequence();
                    int version = ber.readInteger();
                    if (version == 1) {
                        ber.readBytes();
                        ber.beginReadSequence();
                        int requestId = ber.readInteger();
                        return requestId;
                    }
                    if (version != 3) break block5;
                    ber.beginReadSequence();
                    ber.readInteger();
                    ber.readInteger();
                    byte securityFlags = ber.readBytes().get();
                    ber.readInteger();
                    ber.endReadSequence();
                    BerReader secBer = new BerReader(ber.readBytes());
                    secBer.beginReadSequence();
                    secBer.readBytes();
                    secBer.readInteger();
                    secBer.readInteger();
                    secBer.readBytes();
                    secBer.readBytes();
                    secBer.readBytes();
                    secBer.endReadSequence();
                    if ((securityFlags & 2) == 0) break block6;
                    return null;
                }
                catch (IOException ioe) {
                    LOGGER.error("Invalid response packet", (Throwable)ioe);
                    return null;
                }
            }
            BerReader pdu = ber;
            pdu.beginReadSequence();
            pdu.readBytes();
            pdu.readBytes();
            int s = pdu.beginReadSequence();
            if (s != 168 && s != 162) {
                throw new IOException("Not a response packet");
            }
            int requestId = ber.readInteger();
            return requestId;
        }
        return null;
    }

    public ByteBuffer transform(ByteBuffer packet, Integer requestId) {
        int errorIndex;
        int errorStatus;
        BerReader ber;
        LinkedList<SnmpResult> results;
        block13: {
            block14: {
                block16: {
                    byte securityFlags;
                    block15: {
                        LOGGER.trace("Transforming packet with requestId = {}", (Object)requestId);
                        results = new LinkedList<SnmpResult>();
                        ber = new BerReader(packet);
                        ber.beginReadSequence();
                        int version = ber.readInteger();
                        if (version == 1) {
                            ber.readBytes();
                            int s = ber.beginReadSequence();
                            if (s != 162) {
                                throw new IOException("Not a response packet");
                            }
                            ber.readInteger();
                            errorStatus = ber.readInteger();
                            errorIndex = ber.readInteger();
                            ber.beginReadSequence();
                            while (ber.hasRemainingInSequence()) {
                                ber.beginReadSequence();
                                Oid oid = ber.readOid();
                                String value = ber.readValue();
                                if (value != null) {
                                    results.add(new SnmpResult(oid, value));
                                }
                                ber.endReadSequence();
                            }
                            ber.endReadSequence();
                            ber.endReadSequence();
                            break block13;
                        }
                        if (version != 3) break block14;
                        ber.beginReadSequence();
                        ber.readInteger();
                        ber.readInteger();
                        securityFlags = ber.readBytes().get();
                        int securityModel = ber.readInteger();
                        if (securityModel == 3) break block15;
                        return null;
                    }
                    ber.endReadSequence();
                    BerReader secBer = new BerReader(ber.readBytes());
                    secBer.beginReadSequence();
                    secBer.readBytes();
                    secBer.readInteger();
                    secBer.readInteger();
                    secBer.readBytes();
                    secBer.readBytes();
                    secBer.readBytes();
                    secBer.endReadSequence();
                    if ((securityFlags & 2) == 0) break block16;
                    return null;
                }
                try {
                    BerReader pdu = ber;
                    pdu.beginReadSequence();
                    pdu.readBytes();
                    pdu.readBytes();
                    int s = pdu.beginReadSequence();
                    if (s != 168 && s != 162) {
                        throw new IOException("Not a response packet");
                    }
                    pdu.readInteger();
                    errorStatus = pdu.readInteger();
                    errorIndex = pdu.readInteger();
                    pdu.beginReadSequence();
                    while (pdu.hasRemainingInSequence()) {
                        pdu.beginReadSequence();
                        Oid oid = pdu.readOid();
                        String value = pdu.readValue();
                        if (value != null) {
                            results.add(new SnmpResult(oid, value));
                        }
                        pdu.endReadSequence();
                    }
                    pdu.endReadSequence();
                    pdu.endReadSequence();
                }
                catch (IOException ioe) {
                    LOGGER.error("Invalid response packet", (Throwable)ioe);
                    return null;
                }
            }
            return null;
        }
        ber.endReadSequence();
        SequenceBerPacket oidSequence = new SequenceBerPacket(48);
        for (SnmpResult r : results) {
            oidSequence.add(new SequenceBerPacket(48).add(new OidBerPacket(r.oid)).add(new BytesBerPacket(BerPacketUtils.bytes(r.value))));
        }
        SequenceBerPacket root = new SequenceBerPacket(48).add(new IntegerBerPacket(1)).add(new BytesBerPacket(BerPacketUtils.bytes(""))).add(new SequenceBerPacket(162).add(new IntegerBerPacket(requestId)).add(new IntegerBerPacket(errorStatus)).add(new IntegerBerPacket(errorIndex)).add(oidSequence));
        ByteBuffer buffer = ByteBuffer.allocate(BerPacketUtils.typeAndLengthBufferLength(root.lengthBuffer()) + root.length());
        root.write(buffer);
        buffer.flip();
        return buffer;
    }
}

