/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Timeout;
import com.davfx.ninio.snmp.AuthRemoteSpecification;
import com.davfx.ninio.snmp.Cancelable;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.SnmpCallType;
import com.davfx.ninio.snmp.SnmpConnecter;
import com.davfx.ninio.snmp.SnmpConnection;
import com.davfx.ninio.snmp.SnmpReceiver;
import com.davfx.ninio.snmp.SnmpRequestBuilder;
import com.davfx.ninio.snmp.SnmpResult;
import java.io.IOException;

public final class SnmpTimeout {
    private SnmpTimeout() {
    }

    public static SnmpConnecter wrap(final double timeout, final SnmpConnecter wrappee) {
        final Timeout t = new Timeout();
        return new SnmpConnecter(){

            public void close() {
                t.close();
                wrappee.close();
            }

            @Override
            public void connect(SnmpConnection callback) {
                wrappee.connect(callback);
            }

            @Override
            public SnmpRequestBuilder request() {
                return SnmpTimeout.wrap(t, timeout, wrappee.request());
            }
        };
    }

    public static SnmpRequestBuilder wrap(final Timeout t, final double timeout, final SnmpRequestBuilder wrappee) {
        return new SnmpRequestBuilder(){

            @Override
            public SnmpRequestBuilder community(String community) {
                wrappee.community(community);
                return this;
            }

            @Override
            public SnmpRequestBuilder auth(AuthRemoteSpecification authRemoteSpecification) {
                wrappee.auth(authRemoteSpecification);
                return this;
            }

            @Override
            public SnmpRequestBuilder build(Address address, Oid oid) {
                wrappee.build(address, oid);
                return this;
            }

            @Override
            public SnmpRequestBuilder add(Oid oid, String value) {
                wrappee.add(oid, value);
                return this;
            }

            @Override
            public void cancel() {
                wrappee.cancel();
            }

            @Override
            public Cancelable call(SnmpCallType type, final SnmpReceiver callback) {
                final Timeout.Manager m = t.set(timeout);
                final Cancelable c = wrappee.call(type, new SnmpReceiver(){

                    public void failed(IOException ioe) {
                        m.cancel();
                        callback.failed(ioe);
                    }

                    @Override
                    public void received(SnmpResult result) {
                        m.reset();
                        callback.received(result);
                    }

                    @Override
                    public void finished() {
                        m.cancel();
                        callback.finished();
                    }
                });
                m.run(new Runnable(){

                    @Override
                    public void run() {
                        wrappee.cancel();
                        c.cancel();
                        callback.failed(new IOException("Timeout"));
                    }
                });
                return new Cancelable(){

                    @Override
                    public void cancel() {
                        c.cancel();
                        m.cancel();
                        wrappee.cancel();
                    }
                };
            }
        };
    }
}

