/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.BerConstants;
import com.davfx.ninio.snmp.BerPacket;
import com.davfx.ninio.snmp.BerPacketUtils;
import com.davfx.ninio.snmp.BytesBerPacket;
import com.davfx.ninio.snmp.IntegerBerPacket;
import com.davfx.ninio.snmp.NullBerPacket;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.OidBerPacket;
import com.davfx.ninio.snmp.SequenceBerPacket;
import com.davfx.ninio.snmp.SnmpResult;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public final class Version2cPacketBuilder {
    private final ByteBuffer buffer;

    private Version2cPacketBuilder(String community, int requestId, int type, int bulkLength, Iterable<OidValue> oidValues) {
        SequenceBerPacket seq = new SequenceBerPacket(48);
        for (OidValue oidValue : oidValues) {
            seq.add(new SequenceBerPacket(48).add(new OidBerPacket(oidValue.oid)).add(oidValue.value.ber()));
        }
        SequenceBerPacket root = new SequenceBerPacket(48).add(new IntegerBerPacket(1)).add(new BytesBerPacket(BerPacketUtils.bytes(community))).add(new SequenceBerPacket(type).add(new IntegerBerPacket(requestId)).add(new IntegerBerPacket(0)).add(new IntegerBerPacket(bulkLength)).add(seq));
        this.buffer = ByteBuffer.allocate(BerPacketUtils.typeAndLengthBufferLength(root.lengthBuffer()) + root.length());
        root.write(this.buffer);
        this.buffer.flip();
    }

    private static Iterable<OidValue> single(Oid oid) {
        LinkedList<OidValue> l = new LinkedList<OidValue>();
        l.add(new OidValue(oid, new Value(){

            @Override
            public BerPacket ber() {
                return new NullBerPacket();
            }
        }));
        return l;
    }

    public static Version2cPacketBuilder getBulk(String community, int requestId, Oid oid, int bulkLength) {
        return new Version2cPacketBuilder(community, requestId, 165, bulkLength, Version2cPacketBuilder.single(oid));
    }

    public static Version2cPacketBuilder get(String community, int requestId, Oid oid) {
        return new Version2cPacketBuilder(community, requestId, 160, 0, Version2cPacketBuilder.single(oid));
    }

    public static Version2cPacketBuilder getNext(String community, int requestId, Oid oid) {
        return new Version2cPacketBuilder(community, requestId, 161, 0, Version2cPacketBuilder.single(oid));
    }

    public static Version2cPacketBuilder trap(String community, int requestId, final Oid trapOid, Iterable<SnmpResult> oidValues) {
        LinkedList<OidValue> l = new LinkedList<OidValue>();
        l.add(new OidValue(BerConstants.TIMESTAMP_OID, new Value(){

            @Override
            public BerPacket ber() {
                return new IntegerBerPacket((int)(System.currentTimeMillis() / 10L));
            }
        }));
        l.add(new OidValue(BerConstants.TRAP_OID, new Value(){

            @Override
            public BerPacket ber() {
                return new OidBerPacket(trapOid);
            }
        }));
        for (final SnmpResult oidValue : oidValues) {
            l.add(new OidValue(oidValue.oid, new Value(){

                @Override
                public BerPacket ber() {
                    return new BytesBerPacket(BerPacketUtils.bytes(oidValue.value));
                }
            }));
        }
        return new Version2cPacketBuilder(community, requestId, 167, 0, l);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    private static final class OidValue {
        public final Oid oid;
        public final Value value;

        public OidValue(Oid oid, Value value) {
            this.oid = oid;
            this.value = value;
        }
    }

    private static interface Value {
        public BerPacket ber();
    }
}

