/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.AuthRemoteSpecification;
import com.google.common.base.Charsets;
import com.google.common.io.BaseEncoding;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthRemoteEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthRemoteEngine.class);
    private static final int ENCRYPTION_MARGIN = 64;
    private int bootCount = 0;
    private int resetTime = 0;
    private byte[] id = new byte[0];
    public final AuthRemoteSpecification authRemoteSpecification;
    private final MessageDigest messageDigest;
    private int packetNumber = 0;
    private byte[] encryptionParameters = new byte[8];
    private final SecureRandom random = new SecureRandom();
    private final Cipher cipher;
    private final int privKeyLength;
    private long timeResetAt = 0L;
    private int time = 0;

    public AuthRemoteEngine(AuthRemoteSpecification authRemoteSpecification) {
        this.authRemoteSpecification = authRemoteSpecification;
        try {
            this.messageDigest = MessageDigest.getInstance(authRemoteSpecification.authDigestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            this.cipher = Cipher.getInstance(String.valueOf(authRemoteSpecification.privEncryptionAlgorithm) + "/" + (authRemoteSpecification.privEncryptionAlgorithm.equals("AES") ? "CFB" : "CBC") + "/" + (authRemoteSpecification.privEncryptionAlgorithm.equals("AES") ? "NoPadding" : "PKCS5Padding"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        this.privKeyLength = authRemoteSpecification.privEncryptionAlgorithm.equals("AES") ? 16 : 8;
    }

    public String getAuthLogin() {
        return this.authRemoteSpecification.authLogin;
    }

    public String getPrivLogin() {
        return this.authRemoteSpecification.privLogin;
    }

    public int incPacketNumber() {
        int n = this.packetNumber++;
        return n;
    }

    public byte[] getEncryptionParameters() {
        return this.encryptionParameters;
    }

    public byte[] getId() {
        return this.id;
    }

    public void setId(byte[] id) {
        LOGGER.trace("Auth engine ID: {} -> {}", (Object)(this.id == null ? null : BaseEncoding.base16().encode(this.id)), (Object)BaseEncoding.base16().encode(id));
        this.id = id;
    }

    public void setEncryptionParameters(byte[] encryptionParameters) {
        this.encryptionParameters = encryptionParameters;
    }

    public int getBootCount() {
        return this.bootCount;
    }

    public void setBootCount(int bootCount) {
        LOGGER.trace("Auth engine boot count: {} -> {}", (Object)this.bootCount, (Object)bootCount);
        this.bootCount = bootCount;
    }

    public int getTime() {
        return this.time;
    }

    public void renewTime() {
        if (this.timeResetAt > 0L) {
            int oldTime = this.time;
            this.time = this.resetTime + (int)((System.currentTimeMillis() - this.timeResetAt) / 1000L);
            LOGGER.trace("Auth engine time: ({}) {} -> {}", new Object[]{this.resetTime, oldTime, this.time});
        }
    }

    public void resetTime(int resetTime) {
        LOGGER.trace("Auth engine reset time: {} ({}) -> {}", new Object[]{this.resetTime, this.time, resetTime});
        this.timeResetAt = System.currentTimeMillis();
        this.resetTime = resetTime;
        this.time = resetTime;
    }

    public byte[] getAuthKey() {
        return this.getKey(this.authRemoteSpecification.authPassword);
    }

    private byte[] getPrivKey() {
        return this.getKey(this.authRemoteSpecification.privPassword);
    }

    private byte[] getKey(String password) {
        byte[] passwordBytes = password.getBytes(Charsets.UTF_8);
        int passwordIndex = 0;
        int count = 0;
        while (count < 0x100000) {
            byte[] b = new byte[64];
            int i = 0;
            while (i < b.length) {
                b[i] = passwordBytes[passwordIndex % passwordBytes.length];
                ++passwordIndex;
                ++i;
            }
            this.messageDigest.update(b);
            count += b.length;
        }
        byte[] digest = this.messageDigest.digest();
        this.messageDigest.reset();
        this.messageDigest.update(digest);
        this.messageDigest.update(this.id);
        this.messageDigest.update(digest);
        return this.messageDigest.digest();
    }

    public byte[] hash(ByteBuffer message) {
        ByteBuffer messageDup = message.duplicate();
        byte[] digest = this.getAuthKey();
        byte[] k_ipad = new byte[64];
        byte[] k_opad = new byte[64];
        int i = 0;
        while (i < digest.length) {
            k_ipad[i] = (byte)(digest[i] ^ 0x36);
            k_opad[i] = (byte)(digest[i] ^ 0x5C);
            ++i;
        }
        i = digest.length;
        while (i < 64) {
            k_ipad[i] = 54;
            k_opad[i] = 92;
            ++i;
        }
        this.messageDigest.update(k_ipad);
        this.messageDigest.update(messageDup);
        byte[] newDigest = this.messageDigest.digest();
        this.messageDigest.reset();
        this.messageDigest.update(k_opad);
        this.messageDigest.update(newDigest);
        newDigest = this.messageDigest.digest();
        byte[] k = new byte[12];
        System.arraycopy(newDigest, 0, k, 0, k.length);
        return k;
    }

    public ByteBuffer encrypt(ByteBuffer decryptedBuffer) {
        byte[] iv;
        byte[] encryptionKey = this.getPrivKey();
        int salt = this.random.nextInt();
        if (this.authRemoteSpecification.privEncryptionAlgorithm.equals("AES")) {
            iv = new byte[16];
            ByteBuffer ivb = ByteBuffer.wrap(iv);
            ivb.putInt(this.getBootCount());
            ivb.putInt(this.getTime());
            ivb.putInt(0);
            ivb.putInt(salt);
            ByteBuffer bb = ByteBuffer.wrap(this.encryptionParameters);
            bb.putInt(0);
            bb.putInt(salt);
        } else {
            ByteBuffer bb = ByteBuffer.wrap(this.encryptionParameters);
            bb.putInt(this.getBootCount());
            bb.putInt(salt);
            iv = new byte[8];
            int i = 0;
            while (i < iv.length) {
                iv[i] = (byte)(encryptionKey[iv.length + i] ^ this.encryptionParameters[i]);
                ++i;
            }
        }
        try {
            this.cipher.init(1, (Key)new SecretKeySpec(encryptionKey, 0, this.privKeyLength, this.authRemoteSpecification.privEncryptionAlgorithm), new IvParameterSpec(iv));
            ByteBuffer b = ByteBuffer.allocate(decryptedBuffer.remaining() + 64);
            this.cipher.doFinal(decryptedBuffer, b);
            b.flip();
            return b;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteBuffer decrypt(ByteBuffer encryptedBuffer) {
        byte[] iv;
        byte[] decryptionKey = this.getPrivKey();
        if (this.authRemoteSpecification.privEncryptionAlgorithm.equals("AES")) {
            iv = new byte[16];
            ByteBuffer ivb = ByteBuffer.wrap(iv);
            ivb.putInt(this.getBootCount());
            ivb.putInt(this.getTime());
            ByteBuffer bb = ByteBuffer.wrap(this.encryptionParameters);
            ivb.putInt(bb.getInt());
            ivb.putInt(bb.getInt());
        } else {
            iv = new byte[8];
            int i = 0;
            while (i < 8) {
                iv[i] = (byte)(decryptionKey[8 + i] ^ this.encryptionParameters[i]);
                ++i;
            }
        }
        try {
            SecretKeySpec key = new SecretKeySpec(decryptionKey, 0, this.privKeyLength, this.authRemoteSpecification.privEncryptionAlgorithm);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            this.cipher.init(2, (Key)key, ivSpec);
            ByteBuffer b = ByteBuffer.allocate(encryptedBuffer.remaining() + 64);
            this.cipher.doFinal(encryptedBuffer, b);
            b.flip();
            return b;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

