/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.Oid;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.LinkedList;

public final class BerWriter {
    public static final int BUFFER_SIZE = 8192;
    private ByteBuffer buffer;
    private final Deque<ByteBuffer> buffers = new LinkedList<ByteBuffer>();

    public BerWriter(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    private void pushBuffer() {
        ByteBuffer b = ByteBuffer.allocate(8192);
        this.buffers.addFirst(this.buffer);
        this.buffer = b;
    }

    private void popBuffer() {
        this.buffer = this.buffers.removeFirst();
    }

    private void willWriteLength() {
        this.pushBuffer();
    }

    private void doWriteLength() {
        ByteBuffer toWrite = this.buffer;
        this.popBuffer();
        int length = toWrite.position();
        if (length < 128) {
            this.buffer.put((byte)length);
        } else {
            int mask = 255;
            int bits = 0;
            int count = 0;
            while (true) {
                ++count;
                if ((length & (mask <<= 8)) == 0) break;
                bits += 8;
            }
            this.buffer.put((byte)(0x80 | count));
            while (bits >= 0) {
                int b = length >>> bits & 0xFF;
                this.buffer.put((byte)b);
                bits -= 8;
            }
        }
        this.buffer.put(toWrite.array(), 0, toWrite.position());
    }

    public void writeInteger(int value) {
        this.buffer.put((byte)2);
        this.willWriteLength();
        int mask = -8388608;
        int intsize = 4;
        while (((value & mask) == 0 || (value & mask) == mask) && intsize > 1) {
            --intsize;
            value <<= 8;
        }
        mask = -16777216;
        while (intsize > 0) {
            this.buffer.put((byte)((value & mask) >>> 24));
            value <<= 8;
            --intsize;
        }
        this.doWriteLength();
    }

    /*
     * Unable to fully structure code
     */
    public void writeOid(Oid oid) {
        this.buffer.put((byte)6);
        this.willWriteLength();
        raw = oid.raw;
        if (raw.length < 2) {
            throw new IllegalArgumentException();
        }
        this.buffer.put((byte)(raw[1] + raw[0] * 40L & 255L));
        i = 2;
        while (i < raw.length) {
            block5: {
                value = raw[i];
                mask = -129;
                bits = 0;
                while ((value & (long)(mask <<= 7)) != 0L) {
                    bits += 7;
                }
                break block5;
                while (true) {
                    b = value >>> bits & -129L;
                    if (bits > 0) {
                        b |= 128L;
                    }
                    this.buffer.put((byte)b);
                    bits -= 7;
                    break;
                }
            }
            if (bits >= 0) ** continue;
            ++i;
        }
        this.doWriteLength();
    }

    public void writeString(ByteBuffer s) {
        this.buffer.put((byte)4);
        this.willWriteLength();
        this.buffer.put(s);
        this.doWriteLength();
    }

    public void beginWriteSequence() {
        this.buffer.put((byte)48);
        this.willWriteLength();
    }

    public void endWriteSequence() {
        this.doWriteLength();
    }

    public void beginWriteRequestPdu(int type) {
        this.buffer.put((byte)type);
        this.willWriteLength();
    }

    public void endWriteRequestPdu() {
        this.doWriteLength();
    }

    public void beginWriteResponsePdu() {
        this.buffer.put((byte)-94);
        this.willWriteLength();
    }

    public void endWriteResponsePdu() {
        this.doWriteLength();
    }

    public void writeNull() {
        this.buffer.put((byte)5);
        this.willWriteLength();
        this.doWriteLength();
    }
}

