/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.SnmpResult;
import com.davfx.ninio.snmp.SnmpServerHandler;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;

public final class FromMapSnmpServerHandler
implements SnmpServerHandler {
    private final SortedMap<Oid, String> map;
    private final SnmpServerHandler wrappee;

    public FromMapSnmpServerHandler(SortedMap<Oid, String> map, SnmpServerHandler wrappee) {
        this.map = map;
        this.wrappee = wrappee;
    }

    @Override
    public void from(Oid oid, SnmpServerHandler.Callback callback) {
        SortedMap<Oid, String> tail = this.map.tailMap(oid);
        for (Map.Entry<Oid, String> e : tail.entrySet()) {
            if (!callback.handle(new SnmpResult(e.getKey(), e.getValue()))) break;
        }
    }

    @Override
    public void connected(Address address) {
        if (this.wrappee != null) {
            this.wrappee.connected(address);
        }
    }

    @Override
    public void closed() {
        if (this.wrappee != null) {
            this.wrappee.closed();
        }
    }

    @Override
    public void failed(IOException ioe) {
        if (this.wrappee != null) {
            this.wrappee.failed(ioe);
        }
    }
}

