/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.List;

public final class Oid
implements Comparable<Oid> {
    public final long[] raw;

    public Oid(String dotNotation) {
        List s = Splitter.on((char)'.').splitToList((CharSequence)dotNotation);
        this.raw = new long[s.size()];
        int i = 0;
        for (String e : s) {
            this.raw[i] = Long.parseLong(e);
            ++i;
        }
    }

    public Oid(long[] raw) {
        this.raw = raw;
    }

    public Oid sub(Oid child) {
        if (child.raw.length < this.raw.length) {
            return null;
        }
        int i = 0;
        while (i < this.raw.length) {
            if (this.raw[i] != child.raw[i]) {
                return null;
            }
            ++i;
        }
        long[] r = new long[child.raw.length - this.raw.length];
        System.arraycopy(child.raw, this.raw.length, r, 0, r.length);
        return new Oid(r);
    }

    public Oid append(Oid suffix) {
        long[] r = new long[this.raw.length + suffix.raw.length];
        System.arraycopy(this.raw, 0, r, 0, this.raw.length);
        System.arraycopy(suffix.raw, 0, r, this.raw.length, suffix.raw.length);
        return new Oid(r);
    }

    public int hashCode() {
        return Arrays.hashCode(this.raw);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        long[] lArray = this.raw;
        int n = this.raw.length;
        int n2 = 0;
        while (n2 < n) {
            long e = lArray[n2];
            if (b.length() > 0) {
                b.append('.');
            }
            b.append(String.valueOf(e));
            ++n2;
        }
        return b.toString();
    }

    public boolean isPrefixOf(Oid oid) {
        if (oid.raw.length < this.raw.length) {
            return false;
        }
        int i = 0;
        while (i < this.raw.length) {
            if (this.raw[i] != oid.raw[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Oid)) {
            return false;
        }
        Oid oid = (Oid)o;
        return Arrays.equals(oid.raw, this.raw);
    }

    @Override
    public int compareTo(Oid handledOid) {
        long[] handledOidRaw = handledOid.raw;
        int i = 0;
        while (i < this.raw.length && i < handledOidRaw.length) {
            long h = handledOidRaw[i];
            long o = this.raw[i];
            if (h > o) {
                return -1;
            }
            if (h < o) {
                return 1;
            }
            ++i;
        }
        if (i < this.raw.length) {
            return 1;
        }
        if (i < handledOidRaw.length) {
            return -1;
        }
        return 0;
    }
}

