/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.BerPacket;
import com.davfx.ninio.snmp.BerPacketUtils;
import com.davfx.ninio.snmp.Oid;
import java.nio.ByteBuffer;

public final class OidBerPacket
implements BerPacket {
    private static final int MAX_OID_BUFFER_SIZE = 1024;
    private final ByteBuffer lengthBuffer;
    private final int length;
    private final ByteBuffer bb;

    /*
     * Unable to fully structure code
     */
    public OidBerPacket(Oid oid) {
        super();
        raw = oid.raw;
        if (raw.length < 2) {
            throw new IllegalArgumentException();
        }
        this.bb = ByteBuffer.allocate(1024);
        this.bb.put((byte)(raw[1] + raw[0] * 40L & 255L));
        i = 2;
        while (i < raw.length) {
            block5: {
                value = raw[i];
                mask = -129;
                bits = 0;
                while ((value & (long)(mask <<= 7)) != 0L) {
                    bits += 7;
                }
                break block5;
                while (true) {
                    b = value >>> bits & -129L;
                    if (bits > 0) {
                        b |= 128L;
                    }
                    this.bb.put((byte)b);
                    bits -= 7;
                    break;
                }
            }
            if (bits >= 0) ** continue;
            ++i;
        }
        this.bb.flip();
        this.length = this.bb.remaining();
        this.lengthBuffer = BerPacketUtils.lengthBuffer(this.length);
    }

    @Override
    public void write(ByteBuffer buffer) {
        BerPacketUtils.writeHeader(6, this.lengthBuffer, buffer);
        int p = this.bb.position();
        buffer.put(this.bb);
        this.bb.position(p);
    }

    @Override
    public ByteBuffer lengthBuffer() {
        return this.lengthBuffer;
    }

    @Override
    public int length() {
        return this.length;
    }
}

