/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Connecter;
import com.davfx.ninio.core.Connection;
import com.davfx.ninio.core.NinioBuilder;
import com.davfx.ninio.core.Queue;
import com.davfx.ninio.core.SendCallback;
import com.davfx.ninio.core.UdpSocket;
import com.davfx.ninio.snmp.AuthRemoteEngine;
import com.davfx.ninio.snmp.AuthRemoteSpecification;
import com.davfx.ninio.snmp.Cancelable;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.SnmpConnecter;
import com.davfx.ninio.snmp.SnmpConnection;
import com.davfx.ninio.snmp.SnmpReceiver;
import com.davfx.ninio.snmp.SnmpRequestBuilder;
import com.davfx.ninio.snmp.SnmpRequestBuilderCancelableImpl;
import com.davfx.ninio.snmp.SnmpResult;
import com.davfx.ninio.snmp.Version2cPacketBuilder;
import com.davfx.ninio.snmp.Version2cPacketParser;
import com.davfx.ninio.snmp.Version3PacketBuilder;
import com.davfx.ninio.snmp.Version3PacketParser;
import com.davfx.ninio.snmp.dependencies.Dependencies;
import com.davfx.ninio.util.ConfigUtils;
import com.davfx.ninio.util.MemoryCache;
import com.typesafe.config.Config;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnmpClient
implements SnmpConnecter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnmpClient.class);
    private static final Config CONFIG = ConfigUtils.load((com.davfx.ninio.util.Dependencies)new Dependencies()).getConfig(SnmpClient.class.getPackage().getName());
    public static final int DEFAULT_PORT = 161;
    private static final int BULK_SIZE = CONFIG.getInt("bulkSize");
    private static final double AUTH_ENGINES_CACHE_DURATION = ConfigUtils.getDuration((Config)CONFIG, (String)"auth.cache");
    private final Executor executor;
    private final Connecter connecter;
    private final InstanceMapper instanceMapper;
    private final RequestIdProvider requestIdProvider = new RequestIdProvider();
    private final MemoryCache<Address, AuthRemoteEnginePendingRequestManager> authRemoteEngines = MemoryCache.builder().expireAfterAccess(AUTH_ENGINES_CACHE_DURATION).build();

    public static Builder builder() {
        return new Builder(){
            private Executor executor = null;
            private NinioBuilder<Connecter> connecterFactory = UdpSocket.builder();

            @Override
            public Builder with(Executor executor) {
                this.executor = executor;
                return this;
            }

            @Override
            public Builder with(NinioBuilder<Connecter> connecterFactory) {
                this.connecterFactory = connecterFactory;
                return this;
            }

            public SnmpConnecter create(Queue queue) {
                if (this.executor == null) {
                    throw new NullPointerException("executor");
                }
                return new SnmpClient(this.executor, (Connecter)this.connecterFactory.create(queue), null);
            }
        };
    }

    private SnmpClient(Executor executor, Connecter connecter) {
        this.executor = executor;
        this.connecter = connecter;
        this.instanceMapper = new InstanceMapper(this.requestIdProvider);
    }

    @Override
    public SnmpRequestBuilder request() {
        return new SnmpRequestBuilder(){
            private String community = null;
            private AuthRemoteSpecification authRemoteSpecification = null;
            private Instance instance = null;
            private boolean receiverSet = false;
            private Cancelable cancelable = null;
            private AuthRemoteEnginePendingRequestManager authRemoteEnginePendingRequestManager;

            @Override
            public SnmpRequestBuilder community(String community) {
                this.community = community;
                return this;
            }

            @Override
            public SnmpRequestBuilder auth(AuthRemoteSpecification authRemoteSpecification) {
                this.authRemoteSpecification = authRemoteSpecification;
                return this;
            }

            @Override
            public SnmpRequestBuilder.SnmpRequestBuilderCancelable build(final Address address, Oid oid) {
                if (this.cancelable != null) {
                    throw new IllegalStateException();
                }
                this.instance = new Instance(SnmpClient.this.connecter, SnmpClient.this.instanceMapper, oid, address, this.community);
                this.cancelable = new Cancelable(){

                    @Override
                    public void cancel() {
                        SnmpClient.this.executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                instance.cancel();
                            }
                        });
                    }
                };
                final AuthRemoteSpecification s = this.authRemoteSpecification;
                SnmpClient.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (s != null) {
                            authRemoteEnginePendingRequestManager = (AuthRemoteEnginePendingRequestManager)SnmpClient.this.authRemoteEngines.get((Object)address);
                            if (authRemoteEnginePendingRequestManager == null) {
                                authRemoteEnginePendingRequestManager = new AuthRemoteEnginePendingRequestManager();
                                SnmpClient.this.authRemoteEngines.put((Object)address, (Object)authRemoteEnginePendingRequestManager);
                            }
                            authRemoteEnginePendingRequestManager.update(authRemoteSpecification, address, SnmpClient.this.connecter);
                        }
                    }
                });
                return new SnmpRequestBuilderCancelableImpl(this, this.cancelable);
            }

            @Override
            public Cancelable receive(final SnmpReceiver c) {
                if (this.cancelable == null) {
                    throw new IllegalStateException();
                }
                if (this.receiverSet) {
                    throw new IllegalStateException();
                }
                this.receiverSet = true;
                SnmpClient.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        instance.receiver = c;
                        instance.authRemoteEnginePendingRequestManager = authRemoteEnginePendingRequestManager;
                        instance.launch();
                    }
                });
                return this.cancelable;
            }
        };
    }

    @Override
    public void connect(final SnmpConnection callback) {
        this.connecter.connect(new Connection(){

            public void received(final Address address, final ByteBuffer buffer) {
                SnmpClient.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Iterable<SnmpResult> results;
                        int errorIndex;
                        int errorStatus;
                        int instanceId;
                        LOGGER.trace("Received SNMP packet, size = {}", (Object)buffer.remaining());
                        AuthRemoteEnginePendingRequestManager authRemoteEnginePendingRequestManager = (AuthRemoteEnginePendingRequestManager)SnmpClient.this.authRemoteEngines.get((Object)address);
                        boolean ready = authRemoteEnginePendingRequestManager != null ? authRemoteEnginePendingRequestManager.isReady() : true;
                        try {
                            if (authRemoteEnginePendingRequestManager == null) {
                                Version2cPacketParser parser = new Version2cPacketParser(buffer);
                                instanceId = parser.getRequestId();
                                errorStatus = parser.getErrorStatus();
                                errorIndex = parser.getErrorIndex();
                                results = parser.getResults();
                            } else {
                                Version3PacketParser parser = new Version3PacketParser(authRemoteEnginePendingRequestManager.engine, buffer);
                                instanceId = parser.getRequestId();
                                errorStatus = parser.getErrorStatus();
                                errorIndex = parser.getErrorIndex();
                                results = parser.getResults();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Invalid packet", (Throwable)e);
                            return;
                        }
                        if (authRemoteEnginePendingRequestManager != null) {
                            if (ready && errorStatus == -1) {
                                authRemoteEnginePendingRequestManager.reset();
                            }
                            authRemoteEnginePendingRequestManager.discoverIfNecessary(address, SnmpClient.this.connecter);
                            authRemoteEnginePendingRequestManager.sendPendingRequestsIfReady(address, SnmpClient.this.connecter);
                        }
                        SnmpClient.this.instanceMapper.handle(instanceId, errorStatus, errorIndex, results);
                    }
                });
            }

            public void failed(IOException ioe) {
                callback.failed(ioe);
            }

            public void connected(Address address) {
                callback.connected(address);
            }

            public void closed() {
                callback.closed();
            }
        });
    }

    public void close() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                SnmpClient.this.instanceMapper.close();
            }
        });
        this.connecter.close();
    }

    /* synthetic */ SnmpClient(Executor executor, Connecter connecter, SnmpClient snmpClient) {
        this(executor, connecter);
    }

    private static final class AuthRemoteEnginePendingRequestManager {
        private static final Oid DISCOVER_OID = new Oid(new long[]{1L, 1L});
        public AuthRemoteEngine engine = null;
        public final List<PendingRequest> pendingRequests = new LinkedList<PendingRequest>();

        public void update(AuthRemoteSpecification authRemoteSpecification, Address address, Connecter connector) {
            if (this.engine == null) {
                this.engine = new AuthRemoteEngine(authRemoteSpecification);
                this.discoverIfNecessary(address, connector);
            } else if (!this.engine.authRemoteSpecification.equals(authRemoteSpecification)) {
                this.engine = new AuthRemoteEngine(authRemoteSpecification);
                this.discoverIfNecessary(address, connector);
            }
        }

        public boolean isReady() {
            return this.engine.getId() != null && this.engine.getBootCount() != 0 && this.engine.getTime() != 0;
        }

        public void reset() {
            this.engine = new AuthRemoteEngine(this.engine.authRemoteSpecification);
        }

        public void discoverIfNecessary(Address address, Connecter connector) {
            if (this.engine.getId() == null || this.engine.getBootCount() == 0 || this.engine.getTime() == 0) {
                Version3PacketBuilder builder = Version3PacketBuilder.get(this.engine, 0, DISCOVER_OID);
                ByteBuffer b = builder.getBuffer();
                LOGGER.trace("Writing discover GET v3: {} #{}, packet size = {}", new Object[]{DISCOVER_OID, 0, b.remaining()});
                connector.send(address, b, new SendCallback(){

                    public void sent() {
                    }

                    public void failed(IOException ioe) {
                        IOException e = new IOException("Failed to send discover packet", ioe);
                        for (PendingRequest r : AuthRemoteEnginePendingRequestManager.this.pendingRequests) {
                            r.sendCallback.failed(e);
                        }
                        AuthRemoteEnginePendingRequestManager.this.pendingRequests.clear();
                    }
                });
            }
        }

        public void registerPendingRequest(PendingRequest r) {
            this.pendingRequests.add(r);
        }

        public void sendPendingRequestsIfReady(Address address, Connecter connector) {
            if (this.engine.getId() == null || this.engine.getBootCount() == 0 || this.engine.getTime() == 0) {
                return;
            }
            for (PendingRequest r : this.pendingRequests) {
                switch (r.request) {
                    case 160: {
                        Version3PacketBuilder builder = Version3PacketBuilder.get(this.engine, r.instanceId, r.oid);
                        ByteBuffer b = builder.getBuffer();
                        LOGGER.trace("Writing GET v3: {} #{}, packet size = {}", new Object[]{r.oid, r.instanceId, b.remaining()});
                        connector.send(address, b, r.sendCallback);
                        break;
                    }
                    case 161: {
                        Version3PacketBuilder builder = Version3PacketBuilder.getNext(this.engine, r.instanceId, r.oid);
                        ByteBuffer b = builder.getBuffer();
                        LOGGER.trace("Writing GETNEXT v3: {} #{}, packet size = {}", new Object[]{r.oid, r.instanceId, b.remaining()});
                        connector.send(address, b, r.sendCallback);
                        break;
                    }
                    case 165: {
                        Version3PacketBuilder builder = Version3PacketBuilder.getBulk(this.engine, r.instanceId, r.oid, BULK_SIZE);
                        ByteBuffer b = builder.getBuffer();
                        LOGGER.trace("Writing GETBULK v3: {} #{}, packet size = {}", new Object[]{r.oid, r.instanceId, b.remaining()});
                        connector.send(address, b, r.sendCallback);
                        break;
                    }
                }
            }
            this.pendingRequests.clear();
        }

        public static final class PendingRequest {
            public final int request;
            public final int instanceId;
            public final Oid oid;
            public final SendCallback sendCallback;

            public PendingRequest(int request, int instanceId, Oid oid, SendCallback sendCallback) {
                this.request = request;
                this.instanceId = instanceId;
                this.oid = oid;
                this.sendCallback = sendCallback;
            }
        }
    }

    public static interface Builder
    extends NinioBuilder<SnmpConnecter> {
        public Builder with(Executor var1);

        public Builder with(NinioBuilder<Connecter> var1);
    }

    private static final class Instance {
        private final Connecter connector;
        private final InstanceMapper instanceMapper;
        private SnmpReceiver receiver;
        private final Oid initialRequestOid;
        private Oid requestOid;
        private int shouldRepeatWhat = 160;
        public int instanceId = 0;
        private final Address address;
        private final String community;
        private AuthRemoteEnginePendingRequestManager authRemoteEnginePendingRequestManager = null;

        public Instance(Connecter connector, InstanceMapper instanceMapper, Oid requestOid, Address address, String community) {
            this.connector = connector;
            this.instanceMapper = instanceMapper;
            this.requestOid = requestOid;
            this.initialRequestOid = requestOid;
            this.address = address;
            this.community = community;
        }

        public void launch() {
            this.instanceMapper.map(this);
            this.shouldRepeatWhat = 160;
            this.write();
        }

        public void close() {
            this.shouldRepeatWhat = 0;
            this.requestOid = null;
            this.receiver = null;
        }

        public void cancel() {
            this.instanceMapper.unmap(this);
            this.shouldRepeatWhat = 0;
            this.requestOid = null;
            this.receiver = null;
        }

        private void write() {
            SendCallback sendCallback = new SendCallback(){

                public void sent() {
                }

                public void failed(IOException ioe) {
                    Instance.this.fail(ioe);
                }
            };
            if (this.authRemoteEnginePendingRequestManager == null) {
                switch (this.shouldRepeatWhat) {
                    case 160: {
                        Version2cPacketBuilder builder = Version2cPacketBuilder.get(this.community, this.instanceId, this.requestOid);
                        ByteBuffer b = builder.getBuffer();
                        LOGGER.trace("Writing GET: {} #{} ({}), packet size = {}", new Object[]{this.requestOid, this.instanceId, this.community, b.remaining()});
                        this.connector.send(this.address, b, sendCallback);
                        break;
                    }
                    case 161: {
                        Version2cPacketBuilder builder = Version2cPacketBuilder.getNext(this.community, this.instanceId, this.requestOid);
                        ByteBuffer b = builder.getBuffer();
                        LOGGER.trace("Writing GETNEXT: {} #{} ({}), packet size = {}", new Object[]{this.requestOid, this.instanceId, this.community, b.remaining()});
                        this.connector.send(this.address, b, sendCallback);
                        break;
                    }
                    case 165: {
                        Version2cPacketBuilder builder = Version2cPacketBuilder.getBulk(this.community, this.instanceId, this.requestOid, BULK_SIZE);
                        ByteBuffer b = builder.getBuffer();
                        LOGGER.trace("Writing GETBULK: {} #{} ({}), packet size = {}", new Object[]{this.requestOid, this.instanceId, this.community, b.remaining()});
                        this.connector.send(this.address, b, sendCallback);
                        break;
                    }
                }
            } else {
                this.authRemoteEnginePendingRequestManager.registerPendingRequest(new AuthRemoteEnginePendingRequestManager.PendingRequest(this.shouldRepeatWhat, this.instanceId, this.requestOid, sendCallback));
                this.authRemoteEnginePendingRequestManager.sendPendingRequestsIfReady(this.address, this.connector);
            }
        }

        private void fail(IOException e) {
            this.shouldRepeatWhat = 0;
            this.requestOid = null;
            if (this.receiver != null) {
                this.receiver.failed(e);
            }
            this.receiver = null;
        }

        private void handle(int errorStatus, int errorIndex, Iterable<SnmpResult> results) {
            if (this.requestOid == null) {
                return;
            }
            if (errorStatus == -1) {
                this.fail(new IOException("Authentication engine not synced"));
                return;
            }
            if (errorStatus == -2) {
                this.fail(new IOException("Authentication failed"));
                return;
            }
            if (errorStatus == -3) {
                this.fail(new IOException("Timeout"));
                return;
            }
            if (errorStatus != 0) {
                LOGGER.trace("Received error: {}/{}", (Object)errorStatus, (Object)errorIndex);
            }
            if (this.shouldRepeatWhat == 160) {
                SnmpResult found = null;
                for (SnmpResult r : results) {
                    if (!this.requestOid.equals(r.oid)) continue;
                    LOGGER.trace("Scalar found: {}", (Object)r);
                    found = r;
                }
                if (found != null) {
                    this.requestOid = null;
                    if (this.receiver != null) {
                        this.receiver.received(found);
                        this.receiver.finished();
                    }
                    this.receiver = null;
                    return;
                }
                this.instanceMapper.map(this);
                this.shouldRepeatWhat = 165;
                this.write();
            } else {
                Oid lastOid = null;
                for (SnmpResult r : results) {
                    LOGGER.trace("Received in bulk: {}", (Object)r);
                }
                for (SnmpResult r : results) {
                    if (r.value == null) continue;
                    if (!this.initialRequestOid.isPrefixOf(r.oid)) {
                        LOGGER.trace("{} not prefixed by {}", (Object)r.oid, (Object)this.initialRequestOid);
                        lastOid = null;
                        break;
                    }
                    LOGGER.trace("Addind to results: {}", (Object)r);
                    if (this.receiver != null) {
                        this.receiver.received(r);
                    }
                    lastOid = r.oid;
                }
                if (lastOid != null) {
                    LOGGER.trace("Continuing from: {}", lastOid);
                    this.requestOid = lastOid;
                    this.instanceMapper.map(this);
                    this.shouldRepeatWhat = 165;
                    this.write();
                } else {
                    this.requestOid = null;
                    if (this.receiver != null) {
                        this.receiver.finished();
                    }
                    this.receiver = null;
                }
            }
        }
    }

    private static final class InstanceMapper {
        private final RequestIdProvider requestIdProvider;
        private final Map<Integer, Instance> instances = new HashMap<Integer, Instance>();

        public InstanceMapper(RequestIdProvider requestIdProvider) {
            this.requestIdProvider = requestIdProvider;
        }

        public void map(Instance instance) {
            this.instances.remove(instance.instanceId);
            int instanceId = this.requestIdProvider.get();
            if (this.instances.containsKey(instanceId)) {
                LOGGER.warn("The maximum number of simultaneous request has been reached");
                return;
            }
            this.instances.put(instanceId, instance);
            LOGGER.trace("New instance ID = {}", (Object)instanceId);
            instance.instanceId = instanceId;
        }

        public void unmap(Instance instance) {
            this.instances.remove(instance.instanceId);
            instance.instanceId = 0;
        }

        public void close() {
            for (Instance i : this.instances.values()) {
                i.close();
            }
            this.instances.clear();
        }

        public void handle(int instanceId, int errorStatus, int errorIndex, Iterable<SnmpResult> results) {
            if (instanceId == Integer.MAX_VALUE) {
                LOGGER.trace("Calling all instances (request ID = {})", (Object)Integer.MAX_VALUE);
                LinkedList<Instance> l = new LinkedList<Instance>(this.instances.values());
                this.instances.clear();
                for (Instance i : l) {
                    i.handle(errorStatus, errorIndex, results);
                }
                return;
            }
            Instance i = this.instances.remove(instanceId);
            if (i == null) {
                return;
            }
            i.handle(errorStatus, errorIndex, results);
        }
    }

    private static final class RequestIdProvider {
        private static final Random RANDOM = new SecureRandom();
        public static final int IGNORE_ID = 0;
        private static final int MAX_ID = 2000000000;
        private static final int INITIAL_VARIABILITY = 100000;
        private static int NEXT = 2000000000;
        private static final Object LOCK = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int get() {
            Object object = LOCK;
            synchronized (object) {
                if (NEXT == 2000000000) {
                    NEXT = 1 + RANDOM.nextInt(100000);
                }
                int k = NEXT++;
                return k;
            }
        }
    }
}

