/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Connecter;
import com.davfx.ninio.core.Connection;
import com.davfx.ninio.core.Disconnectable;
import com.davfx.ninio.core.NinioBuilder;
import com.davfx.ninio.core.Nop;
import com.davfx.ninio.core.Queue;
import com.davfx.ninio.core.SendCallback;
import com.davfx.ninio.core.UdpSocket;
import com.davfx.ninio.snmp.BerPacket;
import com.davfx.ninio.snmp.BerPacketUtils;
import com.davfx.ninio.snmp.BerReader;
import com.davfx.ninio.snmp.BytesBerPacket;
import com.davfx.ninio.snmp.IntegerBerPacket;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.OidBerPacket;
import com.davfx.ninio.snmp.SequenceBerPacket;
import com.davfx.ninio.snmp.SnmpResult;
import com.davfx.ninio.snmp.SnmpServerHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnmpServer
implements Disconnectable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnmpServer.class);
    private final Connecter connecter;

    public static Builder builder() {
        return new Builder(){
            private UdpSocket.Builder connectorFactory = UdpSocket.builder();
            private SnmpServerHandler handler = null;

            @Override
            public Builder handle(SnmpServerHandler handler) {
                this.handler = handler;
                return this;
            }

            @Override
            public Builder with(UdpSocket.Builder connectorFactory) {
                this.connectorFactory = connectorFactory;
                return this;
            }

            public Disconnectable create(Queue queue) {
                return new SnmpServer((Connecter)this.connectorFactory.create(queue), this.handler, null);
            }
        };
    }

    private SnmpServer(final Connecter connecter, final SnmpServerHandler handler) {
        this.connecter = connecter;
        connecter.connect(new Connection(){

            public void connected(Address address) {
                handler.connected(address);
            }

            public void closed() {
                handler.closed();
            }

            public void failed(IOException ioe) {
                handler.failed(ioe);
            }

            public void received(Address address, ByteBuffer buffer) {
                LinkedList next;
                Oid oid;
                int bulkLength;
                int requestId;
                int request;
                String community;
                try {
                    BerReader ber = new BerReader(buffer);
                    ber.beginReadSequence();
                    ber.readInteger();
                    community = BerPacketUtils.string(ber.readBytes());
                    request = ber.beginReadSequence();
                    requestId = ber.readInteger();
                    ber.readInteger();
                    bulkLength = ber.readInteger();
                    ber.beginReadSequence();
                    ber.beginReadSequence();
                    oid = ber.readOid();
                    ber.readNull();
                    ber.endReadSequence();
                    ber.endReadSequence();
                    ber.endReadSequence();
                    ber.endReadSequence();
                }
                catch (IOException e) {
                    LOGGER.error("Invalid packet", (Throwable)e);
                    return;
                }
                LOGGER.trace("Request with community: {} and oid: {}", (Object)community, (Object)oid);
                if (request == 160) {
                    next = new LinkedList();
                    if (handler != null) {
                        handler.from(oid, new SnmpServerHandler.Callback(){

                            @Override
                            public boolean handle(SnmpResult result) {
                                if (result.oid.equals(oid)) {
                                    next.add(result);
                                    return false;
                                }
                                return true;
                            }
                        });
                    }
                    if (next.isEmpty()) {
                        LOGGER.trace("GET {}: None", (Object)oid);
                        connecter.send(address, SnmpServer.build(requestId, community, 2, 0, null), (SendCallback)new Nop());
                        return;
                    }
                    LOGGER.trace("GET {}: {}", (Object)oid, next);
                    connecter.send(address, SnmpServer.build(requestId, community, 0, 0, next), (SendCallback)new Nop());
                    return;
                }
                if (request == 161) {
                    next = new LinkedList();
                    if (handler != null) {
                        handler.from(oid, new SnmpServerHandler.Callback(){

                            @Override
                            public boolean handle(SnmpResult result) {
                                if (result.oid.equals(oid)) {
                                    return true;
                                }
                                if (next.isEmpty()) {
                                    next.add(result);
                                }
                                return false;
                            }
                        });
                    }
                    if (next.isEmpty()) {
                        LOGGER.trace("GETNEXT {}: No next", (Object)oid);
                        connecter.send(address, SnmpServer.build(requestId, community, 2, 0, null), (SendCallback)new Nop());
                        return;
                    }
                    LOGGER.trace("GETNEXT {}: {}", (Object)oid, next);
                    connecter.send(address, SnmpServer.build(requestId, community, 0, 0, next), (SendCallback)new Nop());
                    return;
                }
                if (request == 165) {
                    next = new LinkedList();
                    if (handler != null) {
                        handler.from(oid, new SnmpServerHandler.Callback(){

                            @Override
                            public boolean handle(SnmpResult result) {
                                if (!result.oid.equals(oid)) {
                                    next.add(result);
                                }
                                return next.size() < bulkLength;
                            }
                        });
                    }
                    if (next.isEmpty()) {
                        LOGGER.trace("GETBULK {}: No next", (Object)oid);
                        connecter.send(address, SnmpServer.build(requestId, community, 2, 0, null), (SendCallback)new Nop());
                        return;
                    }
                    LOGGER.trace("GETBULK {}: {}", (Object)oid, next);
                    connecter.send(address, SnmpServer.build(requestId, community, 0, 0, next), (SendCallback)new Nop());
                    return;
                }
            }
        });
    }

    private static BerPacket ber(String s) {
        return new BytesBerPacket(BerPacketUtils.bytes(s));
    }

    private static ByteBuffer build(int requestId, String community, int errorStatus, int errorIndex, Iterable<SnmpResult> oidValues) {
        SequenceBerPacket oidSequence = new SequenceBerPacket(48);
        if (oidValues != null) {
            for (SnmpResult ov : oidValues) {
                oidSequence.add(new SequenceBerPacket(48).add(new OidBerPacket(ov.oid)).add(SnmpServer.ber(ov.value)));
            }
        }
        SequenceBerPacket root = new SequenceBerPacket(48).add(new IntegerBerPacket(1)).add(new BytesBerPacket(BerPacketUtils.bytes(community))).add(new SequenceBerPacket(162).add(new IntegerBerPacket(requestId)).add(new IntegerBerPacket(errorStatus)).add(new IntegerBerPacket(errorIndex)).add(oidSequence));
        ByteBuffer buffer = ByteBuffer.allocate(BerPacketUtils.typeAndLengthBufferLength(root.lengthBuffer()) + root.length());
        root.write(buffer);
        buffer.flip();
        return buffer;
    }

    public void close() {
        this.connecter.close();
    }

    /* synthetic */ SnmpServer(Connecter connecter, SnmpServerHandler snmpServerHandler, SnmpServer snmpServer) {
        this(connecter, snmpServerHandler);
    }

    public static interface Builder
    extends NinioBuilder<Disconnectable> {
        public Builder with(UdpSocket.Builder var1);

        public Builder handle(SnmpServerHandler var1);
    }
}

