/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.core.SqliteCache;
import com.davfx.ninio.snmp.BerPacketUtils;
import com.davfx.ninio.snmp.BerReader;
import com.davfx.ninio.snmp.BytesBerPacket;
import com.davfx.ninio.snmp.IntegerBerPacket;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.OidBerPacket;
import com.davfx.ninio.snmp.SequenceBerPacket;
import com.davfx.ninio.snmp.SnmpResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnmpSqliteCacheInterpreter
implements SqliteCache.Interpreter<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnmpSqliteCacheInterpreter.class);

    public SqliteCache.Context<Integer> handleRequest(ByteBuffer packet) {
        try {
            BerReader ber = new BerReader(packet);
            ber.beginReadSequence();
            int version = ber.readInteger();
            if (version != 1) {
                throw new IOException("Invalid version: " + version + " should be " + 1);
            }
            ber.readBytes();
            int type = ber.beginReadSequence();
            int requestId = ber.readInteger();
            ber.readInteger();
            ber.readInteger();
            ber.beginReadSequence();
            if (ber.hasRemainingInSequence()) {
                ber.beginReadSequence();
                Oid oid = ber.readOid();
                ber.readValue();
                String key = oid + "/" + type;
                return new SqliteCache.Context(key, (Object)requestId);
            }
            ber.endReadSequence();
            ber.endReadSequence();
            ber.endReadSequence();
        }
        catch (IOException ioe) {
            LOGGER.error("Invalid request packet", (Throwable)ioe);
        }
        return null;
    }

    public Integer handleResponse(ByteBuffer packet) {
        try {
            BerReader ber = new BerReader(packet);
            ber.beginReadSequence();
            int version = ber.readInteger();
            if (version != 1) {
                throw new IOException("Invalid version: " + version + " should be " + 1);
            }
            ber.readBytes();
            ber.beginReadSequence();
            int requestId = ber.readInteger();
            return requestId;
        }
        catch (IOException ioe) {
            LOGGER.error("Invalid response packet", (Throwable)ioe);
            return null;
        }
    }

    public ByteBuffer transform(ByteBuffer packet, Integer requestId) {
        int errorIndex;
        int errorStatus;
        LOGGER.trace("Transforming packet with requestId = {}", (Object)requestId);
        LinkedList<SnmpResult> results = new LinkedList<SnmpResult>();
        try {
            BerReader ber = new BerReader(packet);
            ber.beginReadSequence();
            int version = ber.readInteger();
            if (version != 1) {
                throw new IOException("Invalid version: " + version + " should be " + 1);
            }
            ber.readBytes();
            int s = ber.beginReadSequence();
            if (s != 162) {
                throw new IOException("Not a response packet");
            }
            ber.readInteger();
            errorStatus = ber.readInteger();
            errorIndex = ber.readInteger();
            ber.beginReadSequence();
            while (ber.hasRemainingInSequence()) {
                ber.beginReadSequence();
                Oid oid = ber.readOid();
                String value = ber.readValue();
                if (value != null) {
                    results.add(new SnmpResult(oid, value));
                }
                ber.endReadSequence();
            }
            ber.endReadSequence();
            ber.endReadSequence();
            ber.endReadSequence();
        }
        catch (IOException ioe) {
            LOGGER.error("Invalid response packet", (Throwable)ioe);
            return null;
        }
        SequenceBerPacket oidSequence = new SequenceBerPacket(48);
        for (SnmpResult r : results) {
            oidSequence.add(new SequenceBerPacket(48).add(new OidBerPacket(r.oid)).add(new BytesBerPacket(BerPacketUtils.bytes(r.value))));
        }
        SequenceBerPacket root = new SequenceBerPacket(48).add(new IntegerBerPacket(1)).add(new BytesBerPacket(BerPacketUtils.bytes(""))).add(new SequenceBerPacket(162).add(new IntegerBerPacket(requestId)).add(new IntegerBerPacket(errorStatus)).add(new IntegerBerPacket(errorIndex)).add(oidSequence));
        ByteBuffer buffer = ByteBuffer.allocate(BerPacketUtils.typeAndLengthBufferLength(root.lengthBuffer()) + root.length());
        root.write(buffer);
        buffer.flip();
        return buffer;
    }
}

