/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Timeout;
import com.davfx.ninio.snmp.AuthRemoteSpecification;
import com.davfx.ninio.snmp.Cancelable;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.SnmpConnecter;
import com.davfx.ninio.snmp.SnmpConnection;
import com.davfx.ninio.snmp.SnmpReceiver;
import com.davfx.ninio.snmp.SnmpRequestBuilder;
import com.davfx.ninio.snmp.SnmpRequestBuilderCancelableImpl;
import com.davfx.ninio.snmp.SnmpResult;
import java.io.IOException;

public final class SnmpTimeout {
    private SnmpTimeout() {
    }

    public static SnmpConnecter wrap(final double timeout, final SnmpConnecter wrappee) {
        final Timeout t = new Timeout();
        return new SnmpConnecter(){

            public void close() {
                t.close();
                wrappee.close();
            }

            @Override
            public void connect(SnmpConnection callback) {
                wrappee.connect(callback);
            }

            @Override
            public SnmpRequestBuilder request() {
                return SnmpTimeout.wrap(t, timeout, wrappee.request());
            }
        };
    }

    public static SnmpRequestBuilder wrap(final Timeout t, final double timeout, final SnmpRequestBuilder wrappee) {
        return new SnmpRequestBuilder(){
            private Timeout.Manager m;
            private Cancelable cancelable;

            @Override
            public SnmpRequestBuilder community(String community) {
                wrappee.community(community);
                return this;
            }

            @Override
            public SnmpRequestBuilder auth(AuthRemoteSpecification authRemoteSpecification) {
                wrappee.auth(authRemoteSpecification);
                return this;
            }

            @Override
            public SnmpRequestBuilder.SnmpRequestBuilderCancelable build(Address address, Oid oid) {
                this.m = t.set(timeout);
                final SnmpRequestBuilder.SnmpRequestBuilderCancelable c = wrappee.build(address, oid);
                this.cancelable = new Cancelable(){

                    @Override
                    public void cancel() {
                        m.cancel();
                        c.cancel();
                    }
                };
                return new SnmpRequestBuilderCancelableImpl(this, this.cancelable);
            }

            @Override
            public Cancelable receive(final SnmpReceiver callback) {
                wrappee.receive(new SnmpReceiver(){

                    public void failed(IOException ioe) {
                        m.cancel();
                        callback.failed(ioe);
                    }

                    @Override
                    public void received(SnmpResult result) {
                        m.reset();
                        callback.received(result);
                    }

                    @Override
                    public void finished() {
                        m.cancel();
                        callback.finished();
                    }
                });
                this.m.run(new Runnable(){

                    @Override
                    public void run() {
                        callback.failed(new IOException("Timeout"));
                    }
                });
                return this.cancelable;
            }
        };
    }
}

