/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.BerReader;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.SnmpResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Version2cPacketParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(Version2cPacketParser.class);
    private final int requestId;
    private final int errorStatus;
    private final int errorIndex;
    private final List<SnmpResult> results = new LinkedList<SnmpResult>();

    public Version2cPacketParser(ByteBuffer buffer) throws IOException {
        BerReader ber = new BerReader(buffer);
        ber.beginReadSequence();
        int version = ber.readInteger();
        if (version != 1) {
            throw new IOException("Invalid version: " + version + " should be " + 1);
        }
        ber.readBytes();
        int s = ber.beginReadSequence();
        if (s != 162) {
            throw new IOException("Not a response packet");
        }
        this.requestId = ber.readInteger();
        this.errorStatus = ber.readInteger();
        this.errorIndex = ber.readInteger();
        ber.beginReadSequence();
        while (ber.hasRemainingInSequence()) {
            ber.beginReadSequence();
            Oid oid = ber.readOid();
            String value = ber.readValue();
            if (value == null) {
                LOGGER.trace("Opaque value: {}", (Object)oid);
            } else {
                this.results.add(new SnmpResult(oid, value));
            }
            ber.endReadSequence();
        }
        ber.endReadSequence();
        ber.endReadSequence();
        ber.endReadSequence();
    }

    public Iterable<SnmpResult> getResults() {
        return this.results;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public int getErrorStatus() {
        return this.errorStatus;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }
}

