/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.AuthRemoteEngine;
import com.davfx.ninio.snmp.BerPacket;
import com.davfx.ninio.snmp.BerPacketUtils;
import com.davfx.ninio.snmp.BytesBerPacket;
import com.davfx.ninio.snmp.BytesSequenceBerPacket;
import com.davfx.ninio.snmp.IntegerBerPacket;
import com.davfx.ninio.snmp.NullBerPacket;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.OidBerPacket;
import com.davfx.ninio.snmp.SequenceBerPacket;
import java.nio.ByteBuffer;

public final class Version3PacketBuilder {
    private final ByteBuffer buffer;

    private Version3PacketBuilder(AuthRemoteEngine authEngine, int requestId, Oid oid, int type, int bulkLength) {
        authEngine.renewTime();
        boolean encrypt = false;
        int securityFlags = 0;
        if (authEngine.getId() != null && authEngine.getAuthLogin() != null) {
            securityFlags |= 1;
            if (authEngine.getPrivLogin() != null) {
                securityFlags |= 2;
                encrypt = true;
            }
        }
        SequenceBerPacket root = new SequenceBerPacket(48).add(new IntegerBerPacket(3)).add(new SequenceBerPacket(48).add(new IntegerBerPacket(authEngine.incPacketNumber())).add(new IntegerBerPacket(65535)).add(new BytesBerPacket(ByteBuffer.wrap(new byte[]{(byte)(securityFlags |= 4)}))).add(new IntegerBerPacket(3)));
        AuthBerPacket auth = new AuthBerPacket();
        PrivacyBerPacket priv = new PrivacyBerPacket();
        root.add(new BytesSequenceBerPacket(new SequenceBerPacket(48).add(new BytesBerPacket(ByteBuffer.wrap(authEngine.getId()))).add(new IntegerBerPacket(authEngine.getBootCount() == 0 ? 1 : authEngine.getBootCount())).add(new IntegerBerPacket(authEngine.getTime() == 0 ? 1 : authEngine.getTime())).add(new BytesBerPacket(BerPacketUtils.bytes(authEngine.getAuthLogin()))).add(auth).add(priv)));
        SequenceBerPacket pduPacket = new SequenceBerPacket(48).add(new BytesBerPacket(ByteBuffer.wrap(authEngine.getId()))).add(new BytesBerPacket(ByteBuffer.allocate(0))).add(new SequenceBerPacket(type).add(new IntegerBerPacket(requestId)).add(new IntegerBerPacket(0)).add(new IntegerBerPacket(bulkLength)).add(new SequenceBerPacket(48).add(new SequenceBerPacket(48).add(new OidBerPacket(oid)).add(new NullBerPacket()))));
        if (encrypt) {
            ByteBuffer decryptedBuffer = ByteBuffer.allocate(BerPacketUtils.typeAndLengthBufferLength(pduPacket.lengthBuffer()) + pduPacket.length());
            pduPacket.write(decryptedBuffer);
            decryptedBuffer.flip();
            root.add(new BytesBerPacket(authEngine.encrypt(decryptedBuffer)));
        } else {
            root.add(pduPacket);
        }
        this.buffer = ByteBuffer.allocate(BerPacketUtils.typeAndLengthBufferLength(root.lengthBuffer()) + root.length());
        root.write(this.buffer);
        this.buffer.flip();
        if (encrypt) {
            Version3PacketBuilder.writeInside(this.buffer, priv.position, authEngine.getEncryptionParameters());
        }
        Version3PacketBuilder.writeInside(this.buffer, auth.position, authEngine.hash(this.buffer));
    }

    private static void writeInside(ByteBuffer buffer, int position, byte[] bytes) {
        int p = buffer.position();
        buffer.position(position);
        buffer.put(bytes);
        buffer.position(p);
    }

    public static Version3PacketBuilder getBulk(AuthRemoteEngine authEngine, int requestId, Oid oid, int bulkLength) {
        return new Version3PacketBuilder(authEngine, requestId, oid, 165, bulkLength);
    }

    public static Version3PacketBuilder get(AuthRemoteEngine authEngine, int requestId, Oid oid) {
        return new Version3PacketBuilder(authEngine, requestId, oid, 160, 0);
    }

    public static Version3PacketBuilder getNext(AuthRemoteEngine authEngine, int requestId, Oid oid) {
        return new Version3PacketBuilder(authEngine, requestId, oid, 161, 0);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    private static final class AuthBerPacket
    implements BerPacket {
        private static final int LENGTH = 12;
        private final ByteBuffer lengthBuffer = BerPacketUtils.lengthBuffer(12);
        private int position = -1;

        @Override
        public void write(ByteBuffer buffer) {
            BerPacketUtils.writeHeader(4, this.lengthBuffer, buffer);
            this.position = buffer.position();
            buffer.put(new byte[12]);
        }

        @Override
        public ByteBuffer lengthBuffer() {
            return this.lengthBuffer;
        }

        @Override
        public int length() {
            return 12;
        }
    }

    private static final class PrivacyBerPacket
    implements BerPacket {
        private static final int LENGTH = 8;
        private final ByteBuffer lengthBuffer = BerPacketUtils.lengthBuffer(8);
        private int position = -1;

        @Override
        public void write(ByteBuffer buffer) {
            BerPacketUtils.writeHeader(4, this.lengthBuffer, buffer);
            this.position = buffer.position();
            buffer.put(new byte[8]);
        }

        @Override
        public ByteBuffer lengthBuffer() {
            return this.lengthBuffer;
        }

        @Override
        public int length() {
            return 8;
        }
    }
}

