/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.snmp;

import com.davfx.ninio.snmp.AuthRemoteEngine;
import com.davfx.ninio.snmp.BerPacketUtils;
import com.davfx.ninio.snmp.BerReader;
import com.davfx.ninio.snmp.Oid;
import com.davfx.ninio.snmp.SnmpResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Version3PacketParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(Version3PacketParser.class);
    private static final Oid AUTH_ERROR_OID_PREFIX = new Oid("1.3.6.1.6.3.15.1.1");
    private static final Oid AUTH_ERROR_UNKNOWN_ENGINE_ID_OID = new Oid("1.3.6.1.6.3.15.1.1.4.0");
    private static final Oid AUTH_ERROR_NOT_IN_TIME_WINDOW_OID = new Oid("1.3.6.1.6.3.15.1.1.2.0");
    private final int requestId;
    private final int errorStatus;
    private final int errorIndex;
    private final List<SnmpResult> results = new LinkedList<SnmpResult>();

    public Version3PacketParser(AuthRemoteEngine authEngine, ByteBuffer buffer) throws IOException {
        int errorIndex;
        int errorStatus;
        int requestId;
        BerReader ber = new BerReader(buffer);
        ber.beginReadSequence();
        int version = ber.readInteger();
        if (version != 3) {
            throw new IOException("Invalid version: " + version + " should be " + 3);
        }
        ber.beginReadSequence();
        ber.readInteger();
        ber.readInteger();
        byte securityFlags = ber.readBytes().get();
        int securityModel = ber.readInteger();
        if (securityModel != 3) {
            throw new IOException("Invalid security model: " + securityModel + " should be " + 3);
        }
        ber.endReadSequence();
        BerReader secBer = new BerReader(ber.readBytes());
        secBer.beginReadSequence();
        ByteBuffer engine = secBer.readBytes();
        byte[] id = new byte[engine.remaining()];
        engine.get(id);
        authEngine.setId(id);
        authEngine.setBootCount(secBer.readInteger());
        authEngine.resetTime(secBer.readInteger());
        String login = BerPacketUtils.string(secBer.readBytes());
        if ((securityFlags & 1) != 0 && !login.equals(authEngine.getAuthLogin())) {
            throw new IOException("Bad login: " + login + " should be: " + authEngine.getAuthLogin());
        }
        secBer.readBytes();
        ByteBuffer decryptParams = secBer.readBytes();
        if (decryptParams.hasRemaining()) {
            byte[] dp = new byte[decryptParams.remaining()];
            decryptParams.get(dp);
            authEngine.setEncryptionParameters(dp);
        }
        secBer.endReadSequence();
        BerReader pdu = (securityFlags & 2) != 0 ? new BerReader(authEngine.decrypt(ber.readBytes())) : ber;
        pdu.beginReadSequence();
        pdu.readBytes();
        pdu.readBytes();
        int s = pdu.beginReadSequence();
        if (s == 168) {
            requestId = pdu.readInteger();
            LOGGER.trace("REPORT <- requestId = {}", (Object)requestId);
            errorStatus = pdu.readInteger();
            errorIndex = pdu.readInteger();
            LOGGER.trace("REPORT error = {}/{}", (Object)errorStatus, (Object)errorIndex);
            if (errorStatus == 0) {
                errorStatus = -4;
                errorIndex = 0;
            }
            pdu.beginReadSequence();
            while (pdu.hasRemainingInSequence()) {
                pdu.beginReadSequence();
                Oid oid = pdu.readOid();
                String value = pdu.readValue();
                LOGGER.trace("<- {} = {}", (Object)oid, (Object)value);
                if (AUTH_ERROR_UNKNOWN_ENGINE_ID_OID.isPrefixOf(oid)) {
                    LOGGER.trace("Engine not known ({}), requestId = {}", (Object)oid, (Object)requestId);
                    errorStatus = -1;
                    errorIndex = 0;
                } else if (AUTH_ERROR_NOT_IN_TIME_WINDOW_OID.isPrefixOf(oid)) {
                    LOGGER.trace("Engine not synced ({}), requestId = {}", (Object)oid, (Object)requestId);
                    errorStatus = -1;
                    errorIndex = 0;
                } else if (AUTH_ERROR_OID_PREFIX.isPrefixOf(oid)) {
                    LOGGER.error("Authentication failed ({}), requestId = {}", (Object)oid, (Object)requestId);
                    errorStatus = -2;
                    errorIndex = 0;
                }
                pdu.endReadSequence();
            }
            pdu.endReadSequence();
        } else {
            if (s != 162) {
                throw new IOException("Not a response packet");
            }
            requestId = pdu.readInteger();
            LOGGER.trace("RESPONSE <- requestId = {}", (Object)requestId);
            errorStatus = pdu.readInteger();
            errorIndex = pdu.readInteger();
            LOGGER.trace("RESPONSE error = {}/{}", (Object)errorStatus, (Object)errorIndex);
            pdu.beginReadSequence();
            while (pdu.hasRemainingInSequence()) {
                pdu.beginReadSequence();
                Oid oid = pdu.readOid();
                String value = pdu.readValue();
                LOGGER.trace("<- {} = {}", (Object)oid, (Object)value);
                if (value != null) {
                    this.results.add(new SnmpResult(oid, value));
                }
                pdu.endReadSequence();
            }
            pdu.endReadSequence();
        }
        pdu.endReadSequence();
        this.requestId = requestId;
        this.errorStatus = errorStatus;
        this.errorIndex = errorIndex;
        ber.endReadSequence();
    }

    public Iterable<SnmpResult> getResults() {
        return this.results;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public int getErrorStatus() {
        return this.errorStatus;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }
}

