/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.telnet;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Closeable;
import com.davfx.ninio.core.CloseableByteBufferHandler;
import com.davfx.ninio.core.FailableCloseableByteBufferHandler;
import com.davfx.ninio.core.Queue;
import com.davfx.ninio.core.SocketListening;
import com.davfx.ninio.telnet.CuttingByteBufferHandler;
import com.davfx.ninio.telnet.TelnetServer;
import com.davfx.ninio.telnet.TelnetSpecification;
import com.google.common.base.Function;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommandTelnetServer
implements AutoCloseable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandTelnetServer.class);
    private static final Config CONFIG = ConfigFactory.load((ClassLoader)CommandTelnetServer.class.getClassLoader());
    private static final int BUFFERING_LIMIT = CONFIG.getBytes("ninio.telnet.sharing.limit").intValue();
    private final Queue queue;
    private boolean closed = false;
    private SocketListening.Listening listening = null;

    public CommandTelnetServer(Queue queue, Address address, final String header, final String cut, final Function<String, String> commandHandler) {
        this.queue = queue;
        new TelnetServer(queue, address, new SocketListening(){

            public void failed(IOException e) {
                LOGGER.error("Failed", (Throwable)e);
            }

            public void close() {
                LOGGER.debug("Closed");
            }

            public void listening(SocketListening.Listening listening) {
                if (CommandTelnetServer.this.closed) {
                    listening.disconnect();
                    listening.close();
                } else {
                    LOGGER.trace("Listening");
                    CommandTelnetServer.this.listening = listening;
                }
            }

            public CloseableByteBufferHandler connected(Address address, final CloseableByteBufferHandler connection) {
                LOGGER.trace("Connected: {}", (Object)address);
                connection.handle(address, ByteBuffer.wrap(header.getBytes(TelnetSpecification.CHARSET)));
                return new CuttingByteBufferHandler(BUFFERING_LIMIT, new FailableCloseableByteBufferHandler(){

                    public void failed(IOException e) {
                        LOGGER.warn("Failed", (Throwable)e);
                        connection.close();
                    }

                    public void close() {
                        connection.close();
                    }

                    public void handle(Address address, ByteBuffer buffer) {
                        String result = (String)commandHandler.apply((Object)new String(buffer.array(), buffer.position(), buffer.remaining() - cut.length(), TelnetSpecification.CHARSET));
                        if (result == null) {
                            connection.close();
                            return;
                        }
                        connection.handle(address, ByteBuffer.wrap(result.getBytes(TelnetSpecification.CHARSET)));
                    }
                }).setPrompt(ByteBuffer.wrap(cut.getBytes(TelnetSpecification.CHARSET)));
            }
        });
    }

    @Override
    public void close() {
        this.queue.post(new Runnable(){

            @Override
            public void run() {
                LOGGER.trace("Closing");
                CommandTelnetServer.this.closed = true;
                if (CommandTelnetServer.this.listening != null) {
                    CommandTelnetServer.this.listening.disconnect();
                    CommandTelnetServer.this.listening.close();
                }
            }
        });
    }
}

