/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.telnet;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Closeable;
import com.davfx.ninio.core.Failable;
import com.davfx.ninio.core.FailableCloseableByteBufferHandler;
import com.davfx.ninio.core.ReadyConnection;
import com.davfx.ninio.telnet.CuttingByteBufferHandler;
import com.davfx.ninio.telnet.TelnetReady;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class CutOnPromptClient {
    public CutOnPromptClient(TelnetReady client, final int limit, final Handler handler) {
        client.connect(new ReadyConnection(){
            private CuttingByteBufferHandler cuttingHandler;

            public void failed(IOException e) {
                handler.failed(e);
            }

            public void close() {
                handler.close();
            }

            public void handle(Address address, ByteBuffer buffer) {
                this.cuttingHandler.handle(address, buffer);
            }

            public void connected(final FailableCloseableByteBufferHandler write) {
                this.cuttingHandler = new CuttingByteBufferHandler(limit, new FailableCloseableByteBufferHandler(){

                    public void failed(IOException e) {
                        handler.failed(e);
                    }

                    public void close() {
                        handler.close();
                    }

                    public void handle(Address address, ByteBuffer buffer) {
                        handler.handle(new String(buffer.array(), buffer.position(), buffer.remaining(), Charsets.UTF_8));
                    }
                });
                handler.connected(new Handler.Write(){

                    @Override
                    public void setPrompt(String prompt) {
                        cuttingHandler.setPrompt(ByteBuffer.wrap(prompt.getBytes(Charsets.UTF_8)));
                    }

                    @Override
                    public void write(String command) {
                        write.handle(null, ByteBuffer.wrap(command.getBytes(Charsets.UTF_8)));
                    }

                    public void close() {
                        write.close();
                    }
                });
            }
        });
    }

    public static interface Handler
    extends Failable,
    Closeable {
        public void connected(Write var1);

        public void handle(String var1);

        public static interface Write
        extends Closeable {
            public void setPrompt(String var1);

            public void write(String var1);
        }
    }
}

