/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.telnet;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.FailableCloseableByteBufferHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

final class CuttingByteBufferHandler
implements FailableCloseableByteBufferHandler {
    private final FailableCloseableByteBufferHandler wrappee;
    private ByteBuffer currentPrompt;
    private List<ByteBuffer> previous = null;
    private final List<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
    private final int limit;
    private int count = 0;

    public CuttingByteBufferHandler(int limit, FailableCloseableByteBufferHandler wrappee) {
        this.limit = limit;
        this.wrappee = wrappee;
    }

    public CuttingByteBufferHandler setPrompt(ByteBuffer prompt) {
        this.currentPrompt = prompt;
        return this;
    }

    public void close() {
        this.buffers.clear();
        this.count = 0;
        this.wrappee.close();
    }

    public void failed(IOException e) {
        this.buffers.clear();
        this.count = 0;
        this.wrappee.failed(e);
    }

    private static int find(ByteBuffer toFind, List<ByteBuffer> intoBuffers) {
        int total = 0;
        int lastLength = 0;
        for (ByteBuffer b : intoBuffers) {
            total += b.remaining();
            lastLength = b.remaining();
        }
        int totalExcludingLast = total - lastLength;
        total -= toFind.remaining() - 1;
        int intoBuffersIndex = 0;
        int backOffset = 0;
        for (int i = 0; i < total; ++i) {
            ByteBuffer first;
            while (i - backOffset == (first = intoBuffers.get(intoBuffersIndex)).remaining()) {
                ++intoBuffersIndex;
                backOffset += first.remaining();
            }
            boolean diff = false;
            ByteBuffer intoBuffer = intoBuffers.get(intoBuffersIndex);
            int l = toFind.remaining();
            for (int j = 0; j < l; ++j) {
                int k;
                byte toFindByte = toFind.get(toFind.position() + j);
                while ((k = i - backOffset + j) == intoBuffer.remaining()) {
                    backOffset += intoBuffer.remaining();
                    intoBuffer = intoBuffers.get(++intoBuffersIndex);
                }
                byte intoBufferByte = intoBuffer.get(intoBuffer.position() + k);
                if (toFindByte == intoBufferByte) continue;
                diff = true;
                break;
            }
            if (diff) continue;
            return i + l - totalExcludingLast;
        }
        return -1;
    }

    public void handle(Address address, ByteBuffer buffer) {
        while (true) {
            ByteBuffer b;
            if (this.previous == null) {
                this.previous = new ArrayList<ByteBuffer>();
            }
            this.previous.add(buffer.duplicate());
            int position = CuttingByteBufferHandler.find(this.currentPrompt, this.previous);
            int lengthToKeep = this.currentPrompt.remaining() - 1;
            ArrayList<ByteBuffer> newPrevious = new ArrayList<ByteBuffer>();
            for (int index = this.previous.size() - 1; lengthToKeep > 0 && index >= 0; lengthToKeep -= b.remaining(), --index) {
                b = this.previous.get(index);
                if (b.remaining() < lengthToKeep) {
                    newPrevious.add(0, b);
                    continue;
                }
                newPrevious.add(0, ByteBuffer.wrap(b.array(), b.position() + b.remaining() - lengthToKeep, lengthToKeep));
                break;
            }
            this.previous = newPrevious;
            if (position < 0) {
                this.buffers.add(buffer);
                this.count += buffer.remaining();
                if (this.limit > 0 && this.count >= this.limit) {
                    this.wrappee.failed(new IOException("Overflow"));
                }
                return;
            }
            ByteBuffer startBuffer = ByteBuffer.wrap(buffer.array(), buffer.position(), position);
            buffer = ByteBuffer.wrap(buffer.array(), buffer.position() + position, buffer.remaining() - position);
            this.buffers.add(startBuffer);
            if (!this.buffers.isEmpty()) {
                int l = 0;
                for (ByteBuffer b2 : this.buffers) {
                    l += b2.remaining();
                }
                byte[] buf = new byte[l];
                int off = 0;
                for (ByteBuffer b3 : this.buffers) {
                    int len = b3.remaining();
                    b3.get(buf, off, len);
                    off += len;
                }
                this.buffers.clear();
                this.count = 0;
                this.wrappee.handle(address, ByteBuffer.wrap(buf));
            }
            this.previous = null;
        }
    }
}

