/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.telnet;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Queue;
import com.davfx.ninio.core.ReadyFactory;
import com.davfx.ninio.core.SocketReadyFactory;
import com.davfx.ninio.telnet.TelnetClient;
import com.davfx.ninio.telnet.TelnetReady;
import com.davfx.ninio.telnet.TelnetSharingReadyFactory;

public final class Telnet {
    public static final int DEFAULT_PORT = 23;
    private static final Queue DEFAULT_QUEUE = new Queue();
    private Queue queue = DEFAULT_QUEUE;
    private Address address = new Address("127.0.0.1", 23);
    private ReadyFactory readyFactory = null;

    public Telnet withQueue(Queue queue) {
        this.queue = queue;
        return this;
    }

    public Telnet to(Address address) {
        this.address = address;
        return this;
    }

    public Telnet override(ReadyFactory readyFactory) {
        this.readyFactory = readyFactory;
        return this;
    }

    public TelnetClient client() {
        return new TelnetClient(this.queue, (ReadyFactory)(this.readyFactory == null ? new SocketReadyFactory(this.queue) : this.readyFactory), this.address);
    }

    public static TelnetSharingReadyFactory sharing() {
        return new TelnetSharingReadyFactory(){

            @Override
            public String eol() {
                return "\r\n";
            }

            @Override
            public TelnetReady create(Queue queue, ReadyFactory readyFactory, Address address) {
                return new TelnetClient(queue, readyFactory, address);
            }
        };
    }
}

