/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.telnet;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.CloseableByteBufferHandler;
import com.davfx.ninio.core.FailableCloseableByteBufferHandler;
import com.davfx.ninio.core.Queue;
import com.davfx.ninio.core.Ready;
import com.davfx.ninio.core.ReadyConnection;
import com.davfx.ninio.core.ReadyFactory;
import com.davfx.ninio.telnet.TelnetReady;
import com.davfx.ninio.telnet.TelnetResponseReader;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class TelnetClient
implements TelnetReady {
    private final Queue queue;
    private final ReadyFactory readyFactory;
    private final Address address;

    public TelnetClient(Queue queue, ReadyFactory readyFactory, Address address) {
        this.queue = queue;
        this.readyFactory = readyFactory;
        this.address = address;
    }

    @Override
    public void connect(final ReadyConnection clientHandler) {
        this.queue.post(new Runnable(){

            @Override
            public void run() {
                Ready ready = TelnetClient.this.readyFactory.create();
                ready.connect(TelnetClient.this.address, new ReadyConnection(){
                    private FailableCloseableByteBufferHandler write;
                    private TelnetResponseReader reader;

                    public void handle(Address address, ByteBuffer buffer) {
                        this.reader.handle(address, buffer, (CloseableByteBufferHandler)clientHandler, (CloseableByteBufferHandler)this.write);
                    }

                    public void failed(IOException e) {
                        clientHandler.failed(e);
                    }

                    public void connected(FailableCloseableByteBufferHandler write) {
                        this.write = write;
                        this.reader = new TelnetResponseReader();
                        clientHandler.connected(write);
                    }

                    public void close() {
                        clientHandler.close();
                    }
                });
            }
        });
    }
}

