/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.telnet;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.CloseableByteBufferHandler;
import com.davfx.ninio.core.Listen;
import com.davfx.ninio.core.Queue;
import com.davfx.ninio.core.QueueListen;
import com.davfx.ninio.core.SocketListen;
import com.davfx.ninio.core.SocketListening;
import com.davfx.ninio.telnet.TelnetResponseReader;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class TelnetServer {
    public TelnetServer(Queue queue, Address address, final SocketListening socketListening) {
        SocketListen listen = new SocketListen(queue.getSelector(), queue.allocator());
        new QueueListen(queue, (Listen)listen).listen(address, new SocketListening(){

            public void listening(SocketListening.Listening listening) {
                socketListening.listening(listening);
            }

            public void close() {
                socketListening.close();
            }

            public void failed(IOException e) {
                socketListening.failed(e);
            }

            public CloseableByteBufferHandler connected(Address address, final CloseableByteBufferHandler connection) {
                final TelnetResponseReader reader = new TelnetResponseReader();
                final CloseableByteBufferHandler listeningConnection = socketListening.connected(address, new CloseableByteBufferHandler(){

                    public void handle(Address address, ByteBuffer buffer) {
                        connection.handle(address, buffer);
                    }

                    public void close() {
                        connection.close();
                    }
                });
                return new CloseableByteBufferHandler(){

                    public void close() {
                        listeningConnection.close();
                    }

                    public void handle(Address address, ByteBuffer buffer) {
                        reader.handle(address, buffer, listeningConnection, connection);
                    }
                };
            }
        });
    }
}

