/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.telnet;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Closeable;
import com.davfx.ninio.core.Queue;
import com.davfx.ninio.core.ReadyFactory;
import com.davfx.ninio.core.SocketReadyFactory;
import com.davfx.ninio.telnet.CutOnPromptClient;
import com.davfx.ninio.telnet.TelnetSharingHandler;
import com.davfx.ninio.telnet.TelnetSharingReadyFactory;
import com.davfx.ninio.util.QueueScheduled;
import com.davfx.util.ConfigUtils;
import com.davfx.util.DateUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TelnetSharing
implements AutoCloseable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TelnetSharing.class);
    private static final Config CONFIG = ConfigFactory.load((ClassLoader)TelnetSharing.class.getClassLoader());
    private static final double CONNECTIONS_TIME_TO_LIVE = ConfigUtils.getDuration((Config)CONFIG, (String)"ninio.telnet.sharing.ttl");
    private static final double CONNECTIONS_CHECK_TIME = ConfigUtils.getDuration((Config)CONFIG, (String)"ninio.telnet.sharing.check");
    private static final int BUFFERING_LIMIT = CONFIG.getBytes("ninio.telnet.sharing.limit").intValue();
    private final Queue queue;
    private final ReadyFactory readyFactory;
    private final Map<Address, TelnetSharingHandlerManager> map = new HashMap<Address, TelnetSharingHandlerManager>();

    public TelnetSharing(Queue queue, ReadyFactory readyFactory) {
        this.queue = queue;
        this.readyFactory = readyFactory;
    }

    @Override
    public void close() {
        this.queue.post(new Runnable(){

            @Override
            public void run() {
                for (TelnetSharingHandlerManager m : TelnetSharing.this.map.values()) {
                    m.close();
                }
            }
        });
    }

    public TelnetSharingHandler client(TelnetSharingReadyFactory factory, Address address) {
        TelnetSharingHandlerManager m = this.map.get(address);
        if (m == null) {
            m = new TelnetSharingHandlerManager(this.queue, this.readyFactory, address);
            this.map.put(address, m);
        }
        final TelnetSharingHandler handler = m.createHandler(factory);
        return new TelnetSharingHandler(){

            @Override
            public void init(final String command, final String prompt, final TelnetSharingHandler.Callback callback) {
                TelnetSharing.this.queue.post(new Runnable(){

                    @Override
                    public void run() {
                        handler.init(command, prompt, callback);
                    }
                });
            }

            @Override
            public void write(final String command, final String prompt, final TelnetSharingHandler.Callback callback) {
                TelnetSharing.this.queue.post(new Runnable(){

                    @Override
                    public void run() {
                        handler.write(command, prompt, callback);
                    }
                });
            }
        };
    }

    private static final class TelnetSharingHandlerManager {
        private final Queue queue;
        private final ReadyFactory readyFactory;
        private final Address address;
        private State state = State.DISCONNECTED;
        private CutOnPromptClient.Handler.Write write;
        private final List<InitCommand> initCommands = new ArrayList<InitCommand>();
        private final Deque<NextCommand> commands = new LinkedList<NextCommand>();
        private double closeDate = 0.0;
        private final Closeable closeable;
        private boolean closed = false;

        public TelnetSharingHandlerManager(Queue queue, ReadyFactory readyFactory, Address address) {
            this.queue = queue;
            this.readyFactory = readyFactory;
            this.address = address;
            this.closeable = QueueScheduled.schedule((Queue)queue, (double)CONNECTIONS_CHECK_TIME, (Runnable)new Runnable(){

                @Override
                public void run() {
                    double now = DateUtils.now();
                    if (TelnetSharingHandlerManager.this.state == State.CONNECTED && TelnetSharingHandlerManager.this.closeDate > 0.0 && TelnetSharingHandlerManager.this.closeDate <= now) {
                        TelnetSharingHandlerManager.this.doClose(null);
                    }
                }
            });
        }

        void close() {
            this.closed = true;
            LOGGER.trace("Closed: {}", (Object)this.address);
            this.closeable.close();
            if (this.write != null) {
                this.write.close();
            }
            this.doClose(null);
        }

        private void doClose(IOException e) {
            if (e != null) {
                LOGGER.debug("Disconnected with error: {}", (Object)e.getMessage());
                for (InitCommand i : this.initCommands) {
                    for (TelnetSharingHandler.Callback callback : i.callbacks) {
                        callback.failed(e);
                    }
                }
                for (NextCommand c : this.commands) {
                    c.callback.failed(e);
                }
            }
            this.initCommands.clear();
            this.commands.clear();
            this.state = State.DISCONNECTED;
            this.write = null;
            LOGGER.debug("Disconnected from: {}", (Object)this.address);
        }

        public TelnetSharingHandler createHandler(final TelnetSharingReadyFactory factory) {
            return new TelnetSharingHandler(){
                private int initIndex = 0;

                @Override
                public void init(String command, String prompt, TelnetSharingHandler.Callback callback) {
                    if (TelnetSharingHandlerManager.this.state == State.DISCONNECTED) {
                        LOGGER.trace("Init command added: {}", (Object)command);
                        InitCommand i = new InitCommand(prompt, command);
                        i.callbacks.add(callback);
                        TelnetSharingHandlerManager.this.initCommands.add(i);
                    } else {
                        if (this.initIndex >= TelnetSharingHandlerManager.this.initCommands.size()) {
                            LOGGER.warn("Already connecting/connected, could not add init command: {}", (Object)command);
                            return;
                        }
                        InitCommand i = (InitCommand)TelnetSharingHandlerManager.this.initCommands.get(this.initIndex);
                        if (!Objects.equals(i.command, command)) {
                            LOGGER.warn("Already connecting/connected, init command differs: {} (previous was: {})", (Object)command, (Object)i.command);
                            return;
                        }
                        if (i.response != null) {
                            callback.handle(i.response);
                        } else {
                            i.callbacks.add(callback);
                        }
                    }
                    ++this.initIndex;
                }

                @Override
                public void write(String command, String prompt, TelnetSharingHandler.Callback callback) {
                    if (TelnetSharingHandlerManager.this.state == State.DISCONNECTED) {
                        LOGGER.trace("Connecting to: {}", (Object)TelnetSharingHandlerManager.this.address);
                        TelnetSharingHandlerManager.this.state = State.CONNECTING;
                        if (TelnetSharingHandlerManager.this.initCommands.isEmpty()) {
                            throw new IllegalStateException("Init commands required");
                        }
                        new CutOnPromptClient(factory.create(TelnetSharingHandlerManager.this.queue, (ReadyFactory)(TelnetSharingHandlerManager.this.readyFactory == null ? new SocketReadyFactory(TelnetSharingHandlerManager.this.queue) : TelnetSharingHandlerManager.this.readyFactory), TelnetSharingHandlerManager.this.address), BUFFERING_LIMIT, new CutOnPromptClient.Handler(){
                            private int writeIndex = 0;

                            public void failed(IOException e) {
                                TelnetSharingHandlerManager.this.doClose(e);
                            }

                            public void close() {
                                TelnetSharingHandlerManager.this.doClose(new IOException("Closed"));
                            }

                            @Override
                            public void connected(CutOnPromptClient.Handler.Write write) {
                                if (TelnetSharingHandlerManager.this.closed) {
                                    write.close();
                                    return;
                                }
                                TelnetSharingHandlerManager.this.write = write;
                                TelnetSharingHandlerManager.this.state = State.CONNECTED;
                                LOGGER.trace("State: {}", (Object)TelnetSharingHandlerManager.this.state);
                                InitCommand n = (InitCommand)TelnetSharingHandlerManager.this.initCommands.get(0);
                                LOGGER.trace("Prompt: {}", (Object)n.prompt);
                                LOGGER.trace("Init command sent: {}", (Object)n.command);
                                this.doWrite(n.prompt, n.command);
                            }

                            @Override
                            public void handle(String result) {
                                LOGGER.trace("Received: {}", (Object)result);
                                TelnetSharingHandlerManager.this.state = State.CONNECTED;
                                if (this.writeIndex < TelnetSharingHandlerManager.this.initCommands.size()) {
                                    Object n;
                                    InitCommand i = (InitCommand)TelnetSharingHandlerManager.this.initCommands.get(this.writeIndex);
                                    i.response = result;
                                    for (TelnetSharingHandler.Callback callback : i.callbacks) {
                                        callback.handle(result);
                                    }
                                    i.callbacks.clear();
                                    if (this.writeIndex < TelnetSharingHandlerManager.this.initCommands.size() - 1) {
                                        n = (InitCommand)TelnetSharingHandlerManager.this.initCommands.get(this.writeIndex + 1);
                                        LOGGER.trace("Prompt: {}", (Object)((InitCommand)n).prompt);
                                        LOGGER.trace("Init command sent: {}", (Object)((InitCommand)n).command);
                                        this.doWrite(((InitCommand)n).prompt, ((InitCommand)n).command);
                                    } else if (!TelnetSharingHandlerManager.this.commands.isEmpty()) {
                                        n = (NextCommand)TelnetSharingHandlerManager.this.commands.getFirst();
                                        LOGGER.trace("Prompt: {}", (Object)((NextCommand)n).prompt);
                                        LOGGER.trace("Command sent: {}", (Object)((NextCommand)n).command);
                                        this.doWrite(((NextCommand)n).prompt, ((NextCommand)n).command);
                                    }
                                } else {
                                    NextCommand p = (NextCommand)TelnetSharingHandlerManager.this.commands.removeFirst();
                                    p.callback.handle(result);
                                    if (!TelnetSharingHandlerManager.this.commands.isEmpty()) {
                                        NextCommand n = (NextCommand)TelnetSharingHandlerManager.this.commands.getFirst();
                                        LOGGER.trace("Prompt: {}", (Object)n.prompt);
                                        LOGGER.trace("Command sent: {}", (Object)n.command);
                                        this.doWrite(n.prompt, n.command);
                                    }
                                }
                                ++this.writeIndex;
                            }
                        });
                    }
                    LOGGER.trace("State: {}", (Object)TelnetSharingHandlerManager.this.state);
                    if (TelnetSharingHandlerManager.this.state == State.CONNECTED && TelnetSharingHandlerManager.this.commands.isEmpty()) {
                        TelnetSharingHandlerManager.this.commands.add(new NextCommand(prompt, command, callback));
                        LOGGER.trace("Stalled connection: {}", (Object)TelnetSharingHandlerManager.this.address);
                        LOGGER.trace("Prompt: {}", (Object)prompt);
                        LOGGER.trace("Command sent: {}", (Object)command);
                        this.doWrite(prompt, command);
                    } else {
                        TelnetSharingHandlerManager.this.commands.add(new NextCommand(prompt, command, callback));
                    }
                }

                private void doWrite(String prompt, String command) {
                    TelnetSharingHandlerManager.this.state = State.WAITING_RESPONSE;
                    TelnetSharingHandlerManager.this.closeDate = DateUtils.now() + CONNECTIONS_TIME_TO_LIVE;
                    TelnetSharingHandlerManager.this.write.setPrompt(prompt);
                    if (command != null) {
                        String s = command + factory.eol();
                        LOGGER.trace("Sent: /{}/", (Object)s);
                        TelnetSharingHandlerManager.this.write.write(s);
                    }
                }
            };
        }

        private static enum State {
            CONNECTING,
            CONNECTED,
            WAITING_RESPONSE,
            DISCONNECTED;

        }
    }

    private static final class InitCommand {
        public final String command;
        public final String prompt;
        public final List<TelnetSharingHandler.Callback> callbacks = new LinkedList<TelnetSharingHandler.Callback>();
        public String response = null;

        public InitCommand(String prompt, String command) {
            this.command = command;
            this.prompt = prompt;
        }

        public String toString() {
            return this.prompt + this.command;
        }
    }

    private static final class NextCommand {
        public final String command;
        public final String prompt;
        public final TelnetSharingHandler.Callback callback;

        public NextCommand(String prompt, String command, TelnetSharingHandler.Callback callback) {
            this.command = command;
            this.prompt = prompt;
            this.callback = callback;
        }

        public String toString() {
            return this.prompt + this.command;
        }
    }
}

