/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.telnet;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Connection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

final class CuttingReceiver
implements Connection {
    private final Connection wrappee;
    private final ByteBuffer prompt;
    private ByteBuffer currentPrompt;
    private List<ByteBuffer> previous = null;
    private final List<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
    private final int limit;
    private int count = 0;

    public CuttingReceiver(int limit, ByteBuffer prompt, Connection wrappee) {
        this.limit = limit;
        this.prompt = prompt;
        this.wrappee = wrappee;
        this.currentPrompt = prompt.duplicate();
    }

    public CuttingReceiver(int limit, Connection wrappee) {
        this.limit = limit;
        this.prompt = null;
        this.wrappee = wrappee;
        this.currentPrompt = null;
    }

    public void on(ByteBuffer prompt) {
        this.currentPrompt = prompt;
    }

    private static int find(ByteBuffer toFind, List<ByteBuffer> intoBuffers) {
        int total = 0;
        int lastLength = 0;
        for (ByteBuffer b : intoBuffers) {
            total += b.remaining();
            lastLength = b.remaining();
        }
        int totalExcludingLast = total - lastLength;
        total -= toFind.remaining() - 1;
        int intoBuffersIndex = 0;
        int backOffset = 0;
        int i = 0;
        while (i < total) {
            ByteBuffer first;
            while (i - backOffset == (first = intoBuffers.get(intoBuffersIndex)).remaining()) {
                ++intoBuffersIndex;
                backOffset += first.remaining();
            }
            boolean diff = false;
            ByteBuffer intoBuffer = intoBuffers.get(intoBuffersIndex);
            int l = toFind.remaining();
            int j = 0;
            while (j < l) {
                int k;
                byte toFindByte = toFind.get(toFind.position() + j);
                while ((k = i - backOffset + j) == intoBuffer.remaining()) {
                    backOffset += intoBuffer.remaining();
                    intoBuffer = intoBuffers.get(++intoBuffersIndex);
                }
                byte intoBufferByte = intoBuffer.get(intoBuffer.position() + k);
                if (toFindByte != intoBufferByte) {
                    diff = true;
                    break;
                }
                ++j;
            }
            if (!diff) {
                return i + l - totalExcludingLast;
            }
            ++i;
        }
        return -1;
    }

    public void closed() {
        this.wrappee.closed();
    }

    public void connected(Address address) {
        this.wrappee.connected(address);
    }

    public void failed(IOException ioe) {
        this.wrappee.failed(ioe);
    }

    public void received(Address address, ByteBuffer buffer) {
        while (this.currentPrompt != null) {
            if (this.previous == null) {
                this.previous = new ArrayList<ByteBuffer>();
            }
            this.previous.add(buffer.duplicate());
            int position = CuttingReceiver.find(this.currentPrompt, this.previous);
            int lengthToKeep = this.currentPrompt.remaining() - 1;
            int index = this.previous.size() - 1;
            ArrayList<ByteBuffer> newPrevious = new ArrayList<ByteBuffer>();
            while (lengthToKeep > 0 && index >= 0) {
                ByteBuffer b = this.previous.get(index);
                if (b.remaining() < lengthToKeep) {
                    newPrevious.add(0, b);
                    lengthToKeep -= b.remaining();
                } else {
                    newPrevious.add(0, ByteBuffer.wrap(b.array(), b.arrayOffset() + b.position() + b.remaining() - lengthToKeep, lengthToKeep));
                    break;
                }
                --index;
            }
            this.previous = newPrevious;
            if (position < 0) {
                this.buffers.add(buffer);
                this.count += buffer.remaining();
                if (this.limit > 0 && this.count >= this.limit) {
                    for (ByteBuffer b : this.buffers) {
                        this.wrappee.received(address, b);
                    }
                    this.buffers.clear();
                    this.count = 0;
                    this.previous = null;
                }
                return;
            }
            ByteBuffer startBuffer = ByteBuffer.wrap(buffer.array(), buffer.position(), position);
            buffer = ByteBuffer.wrap(buffer.array(), buffer.arrayOffset() + buffer.position() + position, buffer.remaining() - position);
            this.buffers.add(startBuffer);
            for (ByteBuffer b : this.buffers) {
                this.wrappee.received(address, b);
            }
            this.wrappee.received(address, null);
            this.buffers.clear();
            this.count = 0;
            this.previous = null;
            if (this.prompt == null) {
                this.currentPrompt = null;
                continue;
            }
            this.currentPrompt = this.prompt.duplicate();
        }
        return;
    }
}

