/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.telnet;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Connected;
import com.davfx.ninio.core.Connecter;
import com.davfx.ninio.core.Connection;
import com.davfx.ninio.core.NinioBuilder;
import com.davfx.ninio.core.NinioProvider;
import com.davfx.ninio.core.SendCallback;
import com.davfx.ninio.core.TcpSocket;
import com.davfx.ninio.telnet.TelnetReader;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class TelnetClient {
    public static Builder builder() {
        return new Builder(){
            private TcpSocket.Builder builder = null;

            @Override
            public Builder with(TcpSocket.Builder builder) {
                this.builder = builder;
                return this;
            }

            public Connecter create(NinioProvider ninioProvider) {
                if (this.builder == null) {
                    throw new NullPointerException("builder");
                }
                final Connecter connecter = (Connecter)this.builder.create(ninioProvider);
                return new Connecter(){

                    public void connect(final Connection callback) {
                        final TelnetReader telnetReader = new TelnetReader();
                        connecter.connect(new Connection(){

                            public void closed() {
                                callback.closed();
                            }

                            public void connected(Address address) {
                                callback.connected(address);
                            }

                            public void failed(IOException ioe) {
                                callback.failed(ioe);
                            }

                            public void received(Address address, ByteBuffer buffer) {
                                telnetReader.handle(buffer, callback, (Connected)connecter);
                            }
                        });
                    }

                    public void send(Address address, ByteBuffer buffer, SendCallback callback) {
                        connecter.send(address, buffer, callback);
                    }

                    public void close() {
                        connecter.close();
                    }
                };
            }
        };
    }

    private TelnetClient() {
    }

    public static interface Builder
    extends NinioBuilder<Connecter> {
        public Builder with(TcpSocket.Builder var1);
    }
}

