/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.telnet;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Connected;
import com.davfx.ninio.core.Connection;
import com.davfx.ninio.core.Listener;
import com.davfx.ninio.core.Listening;
import com.davfx.ninio.core.NinioBuilder;
import com.davfx.ninio.core.NinioProvider;
import com.davfx.ninio.core.TcpSocketServer;
import com.davfx.ninio.telnet.TelnetReader;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class TelnetServer {
    public static Builder builder() {
        return new Builder(){
            private TcpSocketServer.Builder builder = null;

            @Override
            public Builder with(TcpSocketServer.Builder builder) {
                this.builder = builder;
                return this;
            }

            public Listener create(NinioProvider ninioProvider) {
                if (this.builder == null) {
                    throw new NullPointerException("builder");
                }
                final TelnetReader telnetReader = new TelnetReader();
                final Listener listener = (Listener)this.builder.create(ninioProvider);
                return new Listener(){

                    public void close() {
                        listener.close();
                    }

                    public void listen(final Listening callback) {
                        listener.listen(new Listening(){

                            public Connection connecting(final Connected connected) {
                                final Connection c = callback.connecting(connected);
                                return new Connection(){

                                    public void received(Address address, ByteBuffer buffer) {
                                        telnetReader.handle(buffer, c, connected);
                                    }

                                    public void closed() {
                                        c.closed();
                                    }

                                    public void failed(IOException e) {
                                        c.failed(e);
                                    }

                                    public void connected(Address address) {
                                        c.connected(address);
                                    }
                                };
                            }

                            public void closed() {
                                callback.closed();
                            }

                            public void failed(IOException e) {
                                callback.failed(e);
                            }

                            public void connected(Address address) {
                                callback.connected(address);
                            }
                        });
                    }
                };
            }
        };
    }

    private TelnetServer() {
    }

    public static interface Builder
    extends NinioBuilder<Listener> {
        public Builder with(TcpSocketServer.Builder var1);
    }
}

