/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.telnet;

import com.davfx.ninio.core.Address;
import com.davfx.ninio.core.Connecter;
import com.davfx.ninio.core.ConnectingClosingFailing;
import com.davfx.ninio.core.Connection;
import com.davfx.ninio.core.Disconnectable;
import com.davfx.ninio.core.InMemoryBuffers;
import com.davfx.ninio.core.NinioBuilder;
import com.davfx.ninio.core.NinioProvider;
import com.davfx.ninio.core.SendCallback;
import com.davfx.ninio.telnet.CutOnPromptClientReceiver;
import com.davfx.ninio.telnet.CuttingReceiver;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CutOnPromptClient
implements Disconnectable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CutOnPromptClient.class);
    private static final Charset DEFAULT_CHARSET = Charsets.UTF_8;
    private static final int DEFAULT_LIMIT = 100;
    private static final String DEFAULT_EOL = "\r\n";
    private CutOnPromptClientReceiver currentReceiveCallback;
    private final Connecter connecter;
    private CuttingReceiver cuttingReceiver;
    private final Executor executor;
    private final String endOfLine;
    private final Charset charset;
    private final int limit;

    public static Builder builder() {
        return new Builder(){
            private NinioBuilder<Connecter> builder = null;
            private Charset charset = CutOnPromptClient.access$0();
            private int limit = 100;
            private String eol = "\r\n";

            @Override
            @Deprecated
            public Builder with(Executor executor) {
                return this;
            }

            @Override
            public Builder with(NinioBuilder<Connecter> builder) {
                this.builder = builder;
                return this;
            }

            @Override
            public Builder charset(Charset charset) {
                this.charset = charset;
                return this;
            }

            @Override
            public Builder limit(int limit) {
                this.limit = limit;
                return this;
            }

            @Override
            public Builder eol(String eol) {
                this.eol = eol;
                return this;
            }

            public CutOnPromptClient create(NinioProvider ninioProvider) {
                if (this.builder == null) {
                    throw new NullPointerException("builder");
                }
                return new CutOnPromptClient((Connecter)this.builder.create(ninioProvider), ninioProvider.executor(), this.eol, this.charset, this.limit, null);
            }
        };
    }

    private CutOnPromptClient(Connecter connecter, Executor executor, String endOfLine, Charset charset, int limit) {
        this.connecter = connecter;
        this.executor = executor;
        this.endOfLine = endOfLine;
        this.charset = charset;
        this.limit = limit;
    }

    public void connect(final ConnectingClosingFailing handler) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                CutOnPromptClient.this.cuttingReceiver = new CuttingReceiver(CutOnPromptClient.this.limit, new Connection(){
                    private InMemoryBuffers buffers = null;

                    public void received(Address address, final ByteBuffer buffer) {
                        CutOnPromptClient.this.executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                if (CutOnPromptClient.this.currentReceiveCallback != null) {
                                    if (buffer == null) {
                                        CutOnPromptClient.this.currentReceiveCallback.received(buffers.toString(CutOnPromptClient.this.charset));
                                        buffers = null;
                                    } else {
                                        if (buffers == null) {
                                            buffers = new InMemoryBuffers();
                                        }
                                        buffers.add(buffer);
                                    }
                                }
                            }
                        });
                    }

                    public void closed() {
                        CutOnPromptClient.this.executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                if (CutOnPromptClient.this.currentReceiveCallback != null) {
                                    CutOnPromptClient.this.currentReceiveCallback.received(null);
                                }
                            }
                        });
                        handler.closed();
                    }

                    public void failed(IOException ioe) {
                        CutOnPromptClient.this.executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                if (CutOnPromptClient.this.currentReceiveCallback != null) {
                                    CutOnPromptClient.this.currentReceiveCallback.received(null);
                                }
                            }
                        });
                        handler.failed(ioe);
                    }

                    public void connected(Address address) {
                        handler.connected(address);
                    }
                });
                CutOnPromptClient.this.connecter.connect((Connection)CutOnPromptClient.this.cuttingReceiver);
            }
        });
    }

    public void write(final String command, final String prompt, final CutOnPromptClientReceiver receiveCallback) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                LOGGER.trace("Sending command: {}, with prompt: {}", (Object)command, (Object)prompt);
                CutOnPromptClient.this.cuttingReceiver.on(ByteBuffer.wrap(prompt.getBytes(CutOnPromptClient.this.charset)));
                CutOnPromptClient.this.currentReceiveCallback = receiveCallback;
                if (command != null) {
                    CutOnPromptClient.this.connecter.send(null, ByteBuffer.wrap((String.valueOf(command) + CutOnPromptClient.this.endOfLine).getBytes(CutOnPromptClient.this.charset)), new SendCallback(){

                        public void sent() {
                        }

                        public void failed(IOException ioe) {
                        }
                    });
                }
            }
        });
    }

    public void close() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                CutOnPromptClient.this.connecter.close();
            }
        });
    }

    static /* synthetic */ Charset access$0() {
        return DEFAULT_CHARSET;
    }

    /* synthetic */ CutOnPromptClient(Connecter connecter, Executor executor, String string, Charset charset, int n, CutOnPromptClient cutOnPromptClient) {
        this(connecter, executor, string, charset, n);
    }

    public static interface Builder
    extends NinioBuilder<CutOnPromptClient> {
        public Builder with(NinioBuilder<Connecter> var1);

        @Deprecated
        public Builder with(Executor var1);

        public Builder charset(Charset var1);

        public Builder limit(int var1);

        public Builder eol(String var1);
    }
}

