/*
 * Decompiled with CFR 0.152.
 */
package com.davfx.ninio.telnet;

import com.davfx.ninio.core.Connected;
import com.davfx.ninio.core.Connection;
import com.davfx.ninio.core.Nop;
import com.davfx.ninio.core.SendCallback;
import com.davfx.ninio.telnet.TelnetSpecification;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TelnetReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TelnetReader.class);
    public static final byte DONT = -2;
    public static final byte DO = -3;
    public static final byte WONT = -4;
    public static final byte WILL = -5;
    public static final byte IAC = -1;
    public static final byte SB = -6;
    public static final byte SE = -16;
    public static final byte ECHO = 1;
    private State readingCommand = State.NONE;
    private int lastRequest;
    private final StringBuilder subcommandLine = new StringBuilder();
    private boolean closed = false;

    public static ByteBuffer write(byte response, byte command) {
        return ByteBuffer.wrap(new byte[]{-1, response, command});
    }

    public void handle(ByteBuffer buffer, Connection wrappee, Connected back) {
        if (this.closed) {
            return;
        }
        StringBuilder r = new StringBuilder();
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            switch (this.readingCommand) {
                case SUBCOMMAND: {
                    if (b == -1) {
                        this.readingCommand = State.SUBCOMMAND_IAC;
                        break;
                    }
                    this.subcommandLine.append((char)b);
                    break;
                }
                case SUBCOMMAND_IAC: {
                    if (b == -1) {
                        this.subcommandLine.append((char)b);
                        this.readingCommand = State.SUBCOMMAND;
                        break;
                    }
                    if (b == -16) {
                        this.subcommandLine.setLength(0);
                        this.readingCommand = State.NONE;
                        break;
                    }
                    LOGGER.error("Invalid telnet communication, missing SE");
                    this.closed = true;
                    back.close();
                    return;
                }
                case NONE: {
                    if (b == -1) {
                        this.readingCommand = State.IAC;
                        break;
                    }
                    r.append((char)b);
                    break;
                }
                case IAC: {
                    if (b == -1) {
                        r.append((char)b);
                        this.readingCommand = State.NONE;
                        break;
                    }
                    this.lastRequest = b;
                    this.readingCommand = State.COMMAND;
                    break;
                }
                case COMMAND: {
                    if (this.lastRequest == -6) {
                        this.readingCommand = State.SUBCOMMAND;
                        break;
                    }
                    if (this.lastRequest == -3) {
                        back.send(null, TelnetReader.write((byte)-4, b), (SendCallback)new Nop());
                    } else if (this.lastRequest == -5) {
                        if (b == 1) {
                            back.send(null, TelnetReader.write((byte)-3, b), (SendCallback)new Nop());
                        } else {
                            back.send(null, TelnetReader.write((byte)-2, b), (SendCallback)new Nop());
                        }
                    }
                    this.readingCommand = State.NONE;
                }
            }
        }
        if (r.length() > 0) {
            String s = r.toString();
            wrappee.received(null, ByteBuffer.wrap(s.getBytes(TelnetSpecification.CHARSET)));
        }
    }

    private static enum State {
        NONE,
        IAC,
        COMMAND,
        SUBCOMMAND,
        SUBCOMMAND_IAC;

    }
}

