/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store;

import com.fasterxml.storemate.shared.ByteContainer;
import com.fasterxml.storemate.shared.StorableKey;
import com.fasterxml.storemate.shared.compress.Compression;
import com.fasterxml.storemate.shared.util.IOUtil;
import com.fasterxml.storemate.shared.util.WithBytesCallback;
import com.fasterxml.storemate.store.file.FileManager;
import java.io.File;

public class Storable {
    protected final StorableKey _key;
    protected final ByteContainer _rawEntry;
    protected final long _lastModified;
    protected final Compression _compression;
    protected final boolean _isDeleted;
    protected final boolean _isReplicated;
    protected final int _metadataOffset;
    protected final int _metadataLength;
    protected final int _contentHash;
    protected final long _storageLength;
    protected final long _originalLength;
    protected final int _compressedHash;
    protected final int _externalPathLength;
    protected final int _payloadOffset;

    public String toString() {
        return "Storable: key=" + this._key + ", rawLength=" + this._rawEntry.byteLength() + ", compression=" + this._compression + ", deleted=" + this._isDeleted + ", extPathLen=" + this._externalPathLength;
    }

    public Storable(StorableKey key, ByteContainer bytes, long lastMod, int statusFlags, Compression comp, int externalPathLength, int contentHash, int compressedHash, long originalLength, int metadataOffset, int metadataLength, int payloadOffset, long storageLength) {
        this._key = key;
        this._rawEntry = bytes;
        this._lastModified = lastMod;
        this._isDeleted = (statusFlags & 1) != 0;
        this._isReplicated = (statusFlags & 2) != 0;
        this._compression = comp == null ? Compression.NONE : comp;
        this._externalPathLength = externalPathLength;
        this._contentHash = contentHash;
        this._compressedHash = compressedHash;
        this._originalLength = originalLength;
        this._metadataOffset = metadataOffset;
        this._metadataLength = metadataLength;
        this._payloadOffset = payloadOffset;
        this._storageLength = storageLength;
    }

    public Storable softDeletedCopy(ByteContainer bytes, boolean removeData) {
        int statusFlags = 1;
        if (this._isReplicated) {
            statusFlags |= 2;
        }
        return new Storable(this._key, bytes, this._lastModified, statusFlags, this._compression, removeData ? 0 : this._externalPathLength, this._contentHash, this._compressedHash, this._originalLength, this._metadataOffset, this._metadataLength, this._payloadOffset, removeData ? 0L : this._storageLength);
    }

    public StorableKey getKey() {
        return this._key;
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public Compression getCompression() {
        return this._compression;
    }

    public int getContentHash() {
        return this._contentHash;
    }

    public int getCompressedHash() {
        return this._compressedHash;
    }

    public long getStorageLength() {
        return this._storageLength;
    }

    public long getOriginalLength() {
        return this._originalLength;
    }

    public int getMetadataLength() {
        return this._metadataLength;
    }

    public int getInlineDataLength() {
        if ((long)this._externalPathLength > 0L) {
            return 0;
        }
        return (int)this._storageLength;
    }

    public boolean isDeleted() {
        return this._isDeleted;
    }

    public boolean isReplicated() {
        return this._isReplicated;
    }

    public boolean hasInlineData() {
        return (long)this._externalPathLength == 0L && this._storageLength > 0L;
    }

    public boolean hasExternalData() {
        return (long)this._externalPathLength > 0L;
    }

    public long getActualUncompressedLength() {
        if (this._compression != Compression.NONE) {
            return this._originalLength;
        }
        return this._storageLength;
    }

    public File getExternalFile(FileManager mgr) {
        if (this._externalPathLength <= 0) {
            return null;
        }
        ByteContainer extRef = this._rawEntry.view(this._payloadOffset, this._externalPathLength);
        return mgr.derefenceFile(IOUtil.getAsciiString((ByteContainer)extRef));
    }

    public String getExternalFilePath() {
        if (this._externalPathLength <= 0) {
            return null;
        }
        return IOUtil.getAsciiString((ByteContainer)this._rawEntry.view(this._payloadOffset, this._externalPathLength));
    }

    public ByteContainer getMetadata() {
        if (this._metadataLength <= 0) {
            return ByteContainer.emptyContainer();
        }
        return this._rawEntry.view(this._metadataOffset, this._metadataLength);
    }

    public <T> T withMetadata(WithBytesCallback<T> cb) {
        if (this._metadataLength <= 0) {
            return (T)ByteContainer.emptyContainer().withBytes(cb);
        }
        return (T)this._rawEntry.withBytes(cb, this._metadataOffset, this._metadataLength);
    }

    public ByteContainer getInlinedData() {
        if (this._externalPathLength > 0) {
            return ByteContainer.emptyContainer();
        }
        int len = (int)this._storageLength;
        if (len <= 0) {
            return ByteContainer.emptyContainer();
        }
        return this._rawEntry.view(this._payloadOffset, len);
    }

    public <T> T withInlinedData(WithBytesCallback<T> cb) {
        if (this._externalPathLength > 0) {
            return (T)ByteContainer.emptyContainer().withBytes(cb);
        }
        int len = (int)this._storageLength;
        if (len <= 0) {
            return (T)ByteContainer.emptyContainer().withBytes(cb);
        }
        return (T)this._rawEntry.withBytes(cb, this._payloadOffset, len);
    }

    public byte[] asBytes() {
        return this._rawEntry.asBytes();
    }

    public <T> T withRaw(WithBytesCallback<T> cb) {
        return (T)this._rawEntry.withBytes(cb);
    }

    public <T> T withRawWithoutPayload(WithBytesCallback<T> cb) {
        int len = this._metadataOffset + this._metadataLength;
        return (T)this._rawEntry.withBytes(cb, 0, len);
    }
}

