/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store;

import com.fasterxml.storemate.shared.compress.Compression;
import com.fasterxml.storemate.store.file.FileReference;

public class StorableCreationMetadata
implements Cloneable {
    public long uncompressedSize = -1L;
    public int contentHash;
    public int compressedContentHash;
    public Compression compression;
    public boolean deleted;
    public boolean replicated;
    public long modtime;
    public FileReference dataFile;
    public long storageSize = -1L;

    public StorableCreationMetadata(Compression comp, int contentHash, int compressedContentHash) {
        this.compression = comp;
        this.contentHash = contentHash;
        this.compressedContentHash = compressedContentHash;
    }

    public StorableCreationMetadata clone() {
        try {
            return (StorableCreationMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed clone(): " + e.getMessage(), e);
        }
    }

    public boolean usesCompression() {
        return this.compression != null && this.compression != Compression.NONE;
    }

    public byte compressionAsByte() {
        if (this.compression == null) {
            return 0;
        }
        return (byte)this.compression.asIndex();
    }

    public byte statusAsByte() {
        int status;
        int n = status = this.deleted ? 1 : 0;
        if (this.replicated) {
            status |= 2;
        }
        return (byte)status;
    }
}

