/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store;

import com.fasterxml.storemate.shared.ByteContainer;
import com.fasterxml.storemate.shared.StorableKey;
import com.fasterxml.storemate.shared.TimeMaster;
import com.fasterxml.storemate.store.Storable;
import com.fasterxml.storemate.store.StorableCreationMetadata;
import com.fasterxml.storemate.store.StorableCreationResult;
import com.fasterxml.storemate.store.StorableDeletionResult;
import com.fasterxml.storemate.store.StoreException;
import com.fasterxml.storemate.store.StoreOperationSource;
import com.fasterxml.storemate.store.StoreOperationThrottler;
import com.fasterxml.storemate.store.backend.IterationResult;
import com.fasterxml.storemate.store.backend.StorableIterationCallback;
import com.fasterxml.storemate.store.backend.StorableLastModIterationCallback;
import com.fasterxml.storemate.store.backend.StoreBackend;
import com.fasterxml.storemate.store.file.FileManager;
import com.fasterxml.storemate.store.util.ByteBufferCallback;
import com.fasterxml.storemate.store.util.OperationDiagnostics;
import com.fasterxml.storemate.store.util.OverwriteChecker;
import java.io.IOException;
import java.io.InputStream;

public abstract class StorableStore {
    public abstract void start() throws Exception;

    public abstract void prepareForStop() throws Exception;

    public abstract void stop() throws Exception;

    public abstract boolean isClosed();

    public abstract FileManager getFileManager();

    public abstract TimeMaster getTimeMaster();

    public abstract StoreBackend getBackend();

    public abstract StoreOperationThrottler getThrottler();

    public abstract <T> T leaseOffHeapBuffer(ByteBufferCallback<T> var1);

    public abstract long getEntryCount();

    public abstract long getIndexedCount();

    public abstract long getOldestInFlightTimestamp();

    public abstract boolean hasEntry(StoreOperationSource var1, OperationDiagnostics var2, StorableKey var3) throws IOException, StoreException;

    public abstract Storable findEntry(StoreOperationSource var1, OperationDiagnostics var2, StorableKey var3) throws IOException, StoreException;

    public abstract StorableCreationResult insert(StoreOperationSource var1, OperationDiagnostics var2, StorableKey var3, InputStream var4, StorableCreationMetadata var5, ByteContainer var6) throws IOException, StoreException;

    public abstract StorableCreationResult insert(StoreOperationSource var1, OperationDiagnostics var2, StorableKey var3, ByteContainer var4, StorableCreationMetadata var5, ByteContainer var6) throws IOException, StoreException;

    public abstract StorableCreationResult upsert(StoreOperationSource var1, OperationDiagnostics var2, StorableKey var3, InputStream var4, StorableCreationMetadata var5, ByteContainer var6, boolean var7) throws IOException, StoreException;

    public abstract StorableCreationResult upsert(StoreOperationSource var1, OperationDiagnostics var2, StorableKey var3, ByteContainer var4, StorableCreationMetadata var5, ByteContainer var6, boolean var7) throws IOException, StoreException;

    public abstract StorableCreationResult upsertConditionally(StoreOperationSource var1, OperationDiagnostics var2, StorableKey var3, InputStream var4, StorableCreationMetadata var5, ByteContainer var6, boolean var7, OverwriteChecker var8) throws IOException, StoreException;

    public abstract StorableCreationResult upsertConditionally(StoreOperationSource var1, OperationDiagnostics var2, StorableKey var3, ByteContainer var4, StorableCreationMetadata var5, ByteContainer var6, boolean var7, OverwriteChecker var8) throws IOException, StoreException;

    public abstract StorableDeletionResult softDelete(StoreOperationSource var1, OperationDiagnostics var2, StorableKey var3, boolean var4, boolean var5) throws IOException, StoreException;

    public abstract StorableDeletionResult hardDelete(StoreOperationSource var1, OperationDiagnostics var2, StorableKey var3, boolean var4) throws IOException, StoreException;

    public abstract IterationResult iterateEntriesByKey(StoreOperationSource var1, OperationDiagnostics var2, StorableKey var3, StorableIterationCallback var4) throws StoreException;

    public abstract IterationResult iterateEntriesAfterKey(StoreOperationSource var1, OperationDiagnostics var2, StorableKey var3, StorableIterationCallback var4) throws StoreException;

    public abstract IterationResult iterateEntriesByModifiedTime(StoreOperationSource var1, OperationDiagnostics var2, long var3, StorableLastModIterationCallback var5) throws StoreException;
}

