/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store;

import com.fasterxml.storemate.store.impl.StorableConverter;
import java.io.File;
import org.skife.config.DataAmount;

public class StoreConfig {
    public static final int DEFAULT_MAX_INLINED = 4000;
    public static final int DEFAULT_MIN_FOR_COMPRESS = 200;
    public static final int DEFAULT_MAX_FOR_GZIP = 16000;
    public static final int DEFAULT_MIN_PAYLOAD_FOR_STREAMING = 64000;
    public static final int DEFAULT_LOCK_PARTITIONS = 64;
    public boolean compressionEnabled = true;
    public boolean requireChecksumForPreCompressed = true;
    public int lockPartitions = 64;
    public File dataRootForFiles;
    public int maxInlinedStorageSize = 4000;
    public int minUncompressedSizeForCompression = 200;
    public int maxUncompressedSizeForGZIP = 16000;
    public int minPayloadForStreaming = 64000;
    public DataAmount offHeapBufferSize = new DataAmount("64MB");
    public DataAmount maxPerEntryBuffering = new DataAmount("1MB");
    public Class<? extends StorableConverter> storableConverter = StorableConverter.class;

    public StorableConverter createStorableConverter() {
        if (this.storableConverter == null || this.storableConverter == StorableConverter.class) {
            return new StorableConverter();
        }
        try {
            return this.storableConverter.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instantiate StorableConverter of type " + this.storableConverter + ": " + e, e);
        }
    }

    public StoreConfig overrideOffHeapBufferSize(long sizeInBytes) {
        this.offHeapBufferSize = new DataAmount(sizeInBytes);
        return this;
    }

    public StoreConfig overrideOffHeapBufferSize(String sizeDesc) {
        this.offHeapBufferSize = new DataAmount(sizeDesc);
        return this;
    }

    public StoreConfig overrideMaxPerEntryBufferSize(long sizeInBytes) {
        this.maxPerEntryBuffering = new DataAmount(sizeInBytes);
        return this;
    }

    public StoreConfig overrideMaxPerEntryBufferSize(String sizeDesc) {
        this.maxPerEntryBuffering = new DataAmount(sizeDesc);
        return this;
    }
}

