/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.file;

import com.fasterxml.storemate.shared.StorableKey;
import com.fasterxml.storemate.shared.util.WithBytesCallback;
import com.fasterxml.storemate.store.file.FilenameConverter;

public class DefaultFilenameConverter
extends FilenameConverter {
    public static final char DEFAULT_SAFE_CHAR = '_';
    protected static final int[] DEFAULTS;
    protected final char _safeChar;

    public DefaultFilenameConverter() {
        this('_');
    }

    public DefaultFilenameConverter(char safeChar) {
        this._safeChar = safeChar;
    }

    protected boolean isSafe(byte b) {
        return DEFAULTS[b & 0xFF] != 0;
    }

    @Override
    public String createFilename(StorableKey rawKey) {
        int expLen = Math.max(8, rawKey.length());
        return this.appendFilename(rawKey, new StringBuilder(expLen)).toString();
    }

    @Override
    public StringBuilder appendFilename(StorableKey rawKey, final StringBuilder sb) {
        rawKey.with((WithBytesCallback)new WithBytesCallback<Void>(){

            public Void withBytes(byte[] buffer, int offset, int length) {
                int end = offset + length;
                while (offset < end) {
                    byte b;
                    sb.append(DefaultFilenameConverter.this.isSafe(b = buffer[offset++]) ? (char)b : DefaultFilenameConverter.this._safeChar);
                }
                return null;
            }
        });
        return sb;
    }

    static {
        int[] def = new int[256];
        String REMOVE = "/\"\\";
        for (int i = 33; i < 127; ++i) {
            char c = (char)i;
            if ("/\"\\".indexOf(c) >= 0) continue;
            def[i] = 1;
        }
        DEFAULTS = def;
    }
}

