/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.file;

import com.fasterxml.storemate.store.file.DirByTime;
import com.fasterxml.storemate.store.file.FileCleanupStats;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirByDate
implements Comparable<DirByDate> {
    private static final Logger LOG = LoggerFactory.getLogger(DirByDate.class);
    static final Pattern DATE_DIR_PATTERN = Pattern.compile("(\\d\\d\\d\\d)\\-(\\d\\d)\\-(\\d\\d)");
    static final Pattern TIME_DIR_PATTERN = Pattern.compile("(\\d\\d):(\\d\\d)");
    protected final File _dir;
    protected final DateTime _createTime;

    public DirByDate(File dir, DateTime createTime) {
        this._dir = dir;
        this._createTime = createTime;
    }

    public static List<DirByDate> listMainDataDirs(File root, FileCleanupStats stats) {
        ArrayList<DirByDate> dirs = new ArrayList<DirByDate>();
        for (File dir : root.listFiles()) {
            Matcher m = DATE_DIR_PATTERN.matcher(dir.getName());
            if (m.matches()) {
                try {
                    int year = Integer.parseInt(m.group(1));
                    int month = Integer.parseInt(m.group(2));
                    int day = Integer.parseInt(m.group(3));
                    MutableDateTime created = new MutableDateTime(0L, DateTimeZone.UTC);
                    created.setTime(0, 0, 0, 0);
                    created.setDate(year, month, day);
                    dirs.add(new DirByDate(dir, created.toDateTime()));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Invalid directory name {}, will skip", (Object)dir.getAbsolutePath());
                }
            }
            if (stats == null) continue;
            stats.addSkippedDir();
        }
        Collections.sort(dirs);
        return dirs;
    }

    public File getDirectory() {
        return this._dir;
    }

    public List<DirByTime> listTimeDirs(FileCleanupStats stats) {
        ArrayList<DirByTime> dirs = new ArrayList<DirByTime>();
        for (File dir : this._dir.listFiles()) {
            Matcher m = TIME_DIR_PATTERN.matcher(dir.getName());
            if (m.matches()) {
                try {
                    int hour = Integer.parseInt(m.group(1));
                    int minute = Integer.parseInt(m.group(2));
                    dirs.add(new DirByTime(dir, this._createTime.withHourOfDay(hour).withMinuteOfHour(minute)));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Invalid directory name {}, will skip", (Object)dir.getAbsolutePath());
                }
            }
            if (stats == null) continue;
            stats.addSkippedDir();
        }
        return dirs;
    }

    public long getRawCreateTime() {
        return this._createTime.getMillis();
    }

    @Override
    public int compareTo(DirByDate other) {
        long thatTime;
        long thisTime = this.getRawCreateTime();
        if (thisTime < (thatTime = other.getRawCreateTime())) {
            return -1;
        }
        if (thisTime > thatTime) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this._dir.getAbsolutePath();
    }
}

