/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.impl;

import com.fasterxml.storemate.shared.StorableKey;
import com.fasterxml.storemate.store.Storable;
import com.fasterxml.storemate.store.backend.IterationAction;
import com.fasterxml.storemate.store.backend.StorableIterationCallback;
import java.util.ArrayList;
import java.util.List;

public abstract class StorableCollector
extends StorableIterationCallback {
    protected final int maxKeys;
    public int total = 0;
    protected final ArrayList<StorableKey> keys;

    public StorableCollector(int maxToCollect) {
        this.maxKeys = maxToCollect;
        this.keys = new ArrayList(maxToCollect);
    }

    public List<StorableKey> getCollected() {
        return this.keys;
    }

    @Override
    public IterationAction verifyKey(StorableKey key) {
        ++this.total;
        return IterationAction.PROCESS_ENTRY;
    }

    @Override
    public IterationAction processEntry(Storable entry) {
        if (this.includeEntry(entry)) {
            this.keys.add(entry.getKey());
            if (this.keys.size() >= this.maxKeys) {
                return IterationAction.TERMINATE_ITERATION;
            }
        }
        return IterationAction.PROCESS_ENTRY;
    }

    public abstract boolean includeEntry(Storable var1);
}

