/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.impl;

import com.fasterxml.storemate.shared.ByteContainer;
import com.fasterxml.storemate.shared.StorableKey;
import com.fasterxml.storemate.shared.TimeMaster;
import com.fasterxml.storemate.shared.compress.Compression;
import com.fasterxml.storemate.shared.compress.Compressors;
import com.fasterxml.storemate.shared.hash.BlockHasher32;
import com.fasterxml.storemate.shared.hash.BlockMurmur3Hasher;
import com.fasterxml.storemate.shared.hash.IncrementalHasher32;
import com.fasterxml.storemate.shared.hash.IncrementalMurmur3Hasher;
import com.fasterxml.storemate.shared.util.BufferRecycler;
import com.fasterxml.storemate.shared.util.IOUtil;
import com.fasterxml.storemate.store.AdminStorableStore;
import com.fasterxml.storemate.store.FileOperationCallback;
import com.fasterxml.storemate.store.Storable;
import com.fasterxml.storemate.store.StorableCreationMetadata;
import com.fasterxml.storemate.store.StorableCreationResult;
import com.fasterxml.storemate.store.StorableDeletionResult;
import com.fasterxml.storemate.store.StoreConfig;
import com.fasterxml.storemate.store.StoreException;
import com.fasterxml.storemate.store.StoreOperationCallback;
import com.fasterxml.storemate.store.StoreOperationSource;
import com.fasterxml.storemate.store.StoreOperationThrottler;
import com.fasterxml.storemate.store.backend.IterationAction;
import com.fasterxml.storemate.store.backend.IterationResult;
import com.fasterxml.storemate.store.backend.StorableIterationCallback;
import com.fasterxml.storemate.store.backend.StorableLastModIterationCallback;
import com.fasterxml.storemate.store.backend.StoreBackend;
import com.fasterxml.storemate.store.file.FileManager;
import com.fasterxml.storemate.store.file.FileReference;
import com.fasterxml.storemate.store.impl.StorableCollector;
import com.fasterxml.storemate.store.impl.StorableConverter;
import com.fasterxml.storemate.store.impl.TombstoneCounter;
import com.fasterxml.storemate.store.util.ByteBufferCallback;
import com.fasterxml.storemate.store.util.CountingOutputStream;
import com.fasterxml.storemate.store.util.OperationDiagnostics;
import com.fasterxml.storemate.store.util.OverwriteChecker;
import com.fasterxml.storemate.store.util.PartitionedWriteMutex;
import com.fasterxml.util.membuf.MemBuffersForBytes;
import com.fasterxml.util.membuf.StreamyBytesMemBuffer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorableStoreImpl
extends AdminStorableStore {
    private static final int HASH_SEED = 0;
    private static final OverwriteChecker OVERWRITE_OK = OverwriteChecker.AlwaysOkToOverwrite.instance;
    private static final OverwriteChecker OVERWRITE_NOT_OK = OverwriteChecker.NeverOkToOverwrite.instance;
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected final int OFF_HEAP_BUFFER_SEGMENT_LEN = 64000;
    protected final boolean _compressionEnabled;
    protected final int _maxInlinedStorageSize;
    protected final int _minCompressibleSize;
    protected final int _maxGZIPCompressibleSize;
    protected final int _minBytesToStream;
    protected final boolean _requireChecksumForPreCompressed;
    protected final TimeMaster _timeMaster;
    protected final FileManager _fileManager;
    protected final StoreBackend _backend;
    protected final StorableConverter _storableConverter;
    protected final PartitionedWriteMutex _writeMutex;
    protected final StoreOperationThrottler _throttler;
    protected static final BufferRecycler _readBuffers = new BufferRecycler(64000);
    protected final MemBuffersForBytes _offHeapBuffers;
    protected final int _maxSegmentsPerBuffer;
    protected final AtomicBoolean _closed = new AtomicBoolean(false);

    @Deprecated
    public StorableStoreImpl(StoreConfig config, StoreBackend physicalStore, TimeMaster timeMaster, FileManager fileManager) {
        this(config, physicalStore, timeMaster, fileManager, null, null);
    }

    public StorableStoreImpl(StoreConfig config, StoreBackend physicalStore, TimeMaster timeMaster, FileManager fileManager, StoreOperationThrottler throttler, PartitionedWriteMutex writeMutex) {
        this._compressionEnabled = config.compressionEnabled;
        this._minCompressibleSize = config.minUncompressedSizeForCompression;
        this._maxGZIPCompressibleSize = config.maxUncompressedSizeForGZIP;
        this._maxInlinedStorageSize = config.maxInlinedStorageSize;
        this._minBytesToStream = config.minPayloadForStreaming;
        this._requireChecksumForPreCompressed = config.requireChecksumForPreCompressed;
        this._backend = physicalStore;
        this._fileManager = fileManager;
        this._timeMaster = timeMaster;
        this._storableConverter = physicalStore.getStorableConverter();
        if (throttler == null) {
            throttler = new StoreOperationThrottler.Base();
        }
        this._throttler = throttler;
        if (writeMutex == null) {
            writeMutex = this.buildDefaultWriteMutex(config);
        }
        this._writeMutex = writeMutex;
        long totalSize = config.offHeapBufferSize.getNumberOfBytes();
        int totalSegments = (int)(totalSize + 64000L - 1L) / 64000;
        if (totalSegments < 10) {
            totalSegments = 10;
        }
        int maxPerBuffer = (int)(config.maxPerEntryBuffering.getNumberOfBytes() + 64000L - 1L) / 64000;
        this._maxSegmentsPerBuffer = Math.max(2, maxPerBuffer);
        this._offHeapBuffers = new MemBuffersForBytes(64000, totalSegments / 4, totalSegments);
    }

    protected PartitionedWriteMutex buildDefaultWriteMutex(StoreConfig config) {
        return new PartitionedWriteMutex(config.lockPartitions, true);
    }

    @Override
    public void start() throws Exception {
        this._backend.start();
    }

    @Override
    public void prepareForStop() throws Exception {
        this._backend.prepareForStop();
    }

    @Override
    public void stop() throws Exception {
        if (!this._closed.getAndSet(true)) {
            this._backend.stop();
        }
    }

    @Override
    public boolean isClosed() {
        return this._closed.get();
    }

    @Override
    public FileManager getFileManager() {
        return this._fileManager;
    }

    @Override
    public TimeMaster getTimeMaster() {
        return this._timeMaster;
    }

    @Override
    public StoreBackend getBackend() {
        return this._backend;
    }

    @Override
    public StoreOperationThrottler getThrottler() {
        return this._throttler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T leaseOffHeapBuffer(ByteBufferCallback<T> cb) {
        StreamyBytesMemBuffer buffer = this.allocOffHeapBuffer();
        try {
            T t = cb.withBuffer(buffer);
            return t;
        }
        finally {
            buffer.close();
        }
    }

    protected StreamyBytesMemBuffer allocOffHeapBuffer() {
        return (StreamyBytesMemBuffer)this._offHeapBuffers.createStreamyBuffer(2, this._maxSegmentsPerBuffer);
    }

    @Override
    public long getEntryCount() {
        this._checkClosed();
        return this._backend.getEntryCount();
    }

    @Override
    public long getIndexedCount() {
        this._checkClosed();
        return this._backend.getIndexedCount();
    }

    @Override
    public long getOldestInFlightTimestamp() {
        return this._writeMutex.getOldestInFlightTimestamp();
    }

    @Override
    public boolean hasEntry(StoreOperationSource source, final OperationDiagnostics diag, StorableKey key) throws StoreException {
        this._checkClosed();
        long operationTime = this._timeMaster.currentTimeMillis();
        final long nanoStart = diag == null ? 0L : this._timeMaster.nanosForDiagnostics();
        try {
            return this._throttler.performHas(source, operationTime, key, new StoreOperationCallback<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean perform(long operationTime, StorableKey key, Storable value) throws StoreException {
                    long dbStart = diag == null ? 0L : StorableStoreImpl.this._timeMaster.nanosForDiagnostics();
                    try {
                        Boolean bl = StorableStoreImpl.this._backend.hasEntry(key);
                        return bl;
                    }
                    finally {
                        if (diag != null) {
                            diag.addDbAccess(nanoStart, dbStart, StorableStoreImpl.this._timeMaster.nanosForDiagnostics());
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw new StoreException.IO(key, "Problem when trying to access entry: " + e.getMessage(), e);
        }
    }

    @Override
    public Storable findEntry(StoreOperationSource source, final OperationDiagnostics diag, StorableKey key) throws StoreException {
        this._checkClosed();
        long operationTime = this._timeMaster.currentTimeMillis();
        final long nanoStart = diag == null ? 0L : this._timeMaster.nanosForDiagnostics();
        try {
            return this._throttler.performGet(source, operationTime, key, new StoreOperationCallback<Storable>(){

                @Override
                public Storable perform(long operationTime, StorableKey key, Storable value) throws IOException, StoreException {
                    long dbStart = diag == null ? 0L : StorableStoreImpl.this._timeMaster.nanosForDiagnostics();
                    Storable result = StorableStoreImpl.this._backend.findEntry(key);
                    if (diag != null) {
                        diag.addDbAccess(nanoStart, dbStart, StorableStoreImpl.this._timeMaster.nanosForDiagnostics());
                        diag.setEntry(result);
                    }
                    return result;
                }
            });
        }
        catch (IOException e) {
            throw new StoreException.IO(key, "Problem when trying to access entry: " + e.getMessage(), e);
        }
    }

    @Override
    public StorableCreationResult insert(StoreOperationSource source, OperationDiagnostics diag, StorableKey key, InputStream input, StorableCreationMetadata stdMetadata, ByteContainer customMetadata) throws IOException, StoreException {
        this._checkClosed();
        return this._putEntry(source, diag, key, input, stdMetadata, customMetadata, OVERWRITE_NOT_OK);
    }

    @Override
    public StorableCreationResult insert(StoreOperationSource source, OperationDiagnostics diag, StorableKey key, ByteContainer input, StorableCreationMetadata stdMetadata, ByteContainer customMetadata) throws IOException, StoreException {
        this._checkClosed();
        return this._putEntry(source, diag, key, input, stdMetadata, customMetadata, OVERWRITE_NOT_OK);
    }

    @Override
    public StorableCreationResult upsert(StoreOperationSource source, OperationDiagnostics diag, StorableKey key, InputStream input, StorableCreationMetadata stdMetadata, ByteContainer customMetadata, boolean removeOldDataFile) throws IOException, StoreException {
        Storable old;
        this._checkClosed();
        StorableCreationResult result = this._putEntry(source, diag, key, input, stdMetadata, customMetadata, OVERWRITE_OK);
        if (removeOldDataFile && (old = result.getPreviousEntry()) != null) {
            this._deleteBackingFile(key, old.getExternalFile(this._fileManager));
        }
        return result;
    }

    @Override
    public StorableCreationResult upsert(StoreOperationSource source, OperationDiagnostics diag, StorableKey key, ByteContainer input, StorableCreationMetadata stdMetadata, ByteContainer customMetadata, boolean removeOldDataFile) throws IOException, StoreException {
        Storable old;
        this._checkClosed();
        StorableCreationResult result = this._putEntry(source, diag, key, input, stdMetadata, customMetadata, OVERWRITE_OK);
        if (removeOldDataFile && (old = result.getPreviousEntry()) != null) {
            this._deleteBackingFile(key, old.getExternalFile(this._fileManager));
        }
        return result;
    }

    @Override
    public StorableCreationResult upsertConditionally(StoreOperationSource source, OperationDiagnostics diag, StorableKey key, InputStream input, StorableCreationMetadata stdMetadata, ByteContainer customMetadata, boolean removeOldDataFile, OverwriteChecker checker) throws IOException, StoreException {
        Storable old;
        this._checkClosed();
        StorableCreationResult result = this._putEntry(source, diag, key, input, stdMetadata, customMetadata, checker);
        if (removeOldDataFile && (old = result.getPreviousEntry()) != null) {
            this._deleteBackingFile(key, old.getExternalFile(this._fileManager));
        }
        return result;
    }

    @Override
    public StorableCreationResult upsertConditionally(StoreOperationSource source, OperationDiagnostics diag, StorableKey key, ByteContainer input, StorableCreationMetadata stdMetadata, ByteContainer customMetadata, boolean removeOldDataFile, OverwriteChecker checker) throws IOException, StoreException {
        Storable old;
        this._checkClosed();
        StorableCreationResult result = this._putEntry(source, diag, key, input, stdMetadata, customMetadata, checker);
        if (removeOldDataFile && (old = result.getPreviousEntry()) != null) {
            this._deleteBackingFile(key, old.getExternalFile(this._fileManager));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StorableCreationResult _putEntry(StoreOperationSource source, OperationDiagnostics diag, StorableKey key, InputStream input, StorableCreationMetadata stdMetadata, ByteContainer customMetadata, OverwriteChecker allowOverwrites) throws IOException, StoreException {
        BufferRecycler.Holder bufferHolder = _readBuffers.getHolder();
        byte[] readBuffer = bufferHolder.borrowBuffer(this._minBytesToStream);
        int len = 0;
        try {
            Compression originalCompression;
            String error;
            long nanoStart = diag == null ? 0L : this._timeMaster.nanosForDiagnostics();
            try {
                len = IOUtil.readFully((InputStream)input, (byte[])readBuffer);
            }
            catch (IOException e) {
                throw new StoreException.IO(key, "Failed to read payload for key " + key + ": " + e.getMessage(), e);
            }
            if (diag != null) {
                diag.addRequestReadTime(nanoStart, this._timeMaster);
            }
            if ((error = IOUtil.verifyCompression((Compression)(originalCompression = stdMetadata.compression), (byte[])readBuffer, (int)len)) != null) {
                throw new StoreException.Input(key, StoreException.InputProblem.BAD_COMPRESSION, error);
            }
            if (len < readBuffer.length) {
                if (originalCompression == null) {
                    StorableCreationResult storableCreationResult = this._compressAndPutSmallEntry(source, diag, key, stdMetadata, customMetadata, allowOverwrites, ByteContainer.simple((byte[])readBuffer, (int)0, (int)len));
                    return storableCreationResult;
                }
                StorableCreationResult storableCreationResult = this._putSmallPreCompressedEntry(source, diag, key, stdMetadata, customMetadata, allowOverwrites, ByteContainer.simple((byte[])readBuffer, (int)0, (int)len));
                return storableCreationResult;
            }
            StorableCreationResult storableCreationResult = this._putLargeEntry(source, diag, key, stdMetadata, customMetadata, allowOverwrites, readBuffer, len, input);
            return storableCreationResult;
        }
        finally {
            bufferHolder.returnBuffer(readBuffer);
        }
    }

    protected StorableCreationResult _putEntry(StoreOperationSource source, OperationDiagnostics diag, StorableKey key, ByteContainer input, StorableCreationMetadata stdMetadata, ByteContainer customMetadata, OverwriteChecker allowOverwrites) throws IOException, StoreException {
        Compression originalCompression = stdMetadata.compression;
        String error = IOUtil.verifyCompression((Compression)originalCompression, (ByteContainer)input);
        if (error != null) {
            throw new StoreException.Input(key, StoreException.InputProblem.BAD_CHECKSUM, error);
        }
        if (originalCompression == null) {
            return this._compressAndPutSmallEntry(source, diag, key, stdMetadata, customMetadata, allowOverwrites, input);
        }
        return this._putSmallPreCompressedEntry(source, diag, key, stdMetadata, customMetadata, allowOverwrites, input);
    }

    protected StorableCreationResult _compressAndPutSmallEntry(StoreOperationSource source, OperationDiagnostics diag, StorableKey key, StorableCreationMetadata metadata, ByteContainer customMetadata, OverwriteChecker allowOverwrites, ByteContainer data) throws IOException, StoreException {
        int origLength = data.byteLength();
        int actualChecksum = StorableStoreImpl._calcChecksum(data);
        int origChecksum = metadata.contentHash;
        if (origChecksum == 0) {
            metadata.contentHash = actualChecksum;
        } else if (origChecksum != actualChecksum) {
            throw new StoreException.Input(key, StoreException.InputProblem.BAD_CHECKSUM, "Incorrect checksum (0x" + Integer.toHexString(origChecksum) + "), calculated to be 0x" + Integer.toHexString(actualChecksum));
        }
        if (this._shouldTryToCompress(metadata, data)) {
            byte[] compBytes;
            Compression compression = null;
            try {
                if (origLength <= this._maxGZIPCompressibleSize) {
                    compression = Compression.GZIP;
                    compBytes = Compressors.gzipCompress((ByteContainer)data);
                } else {
                    compression = Compression.LZF;
                    compBytes = Compressors.lzfCompress((ByteContainer)data);
                }
            }
            catch (IOException e) {
                throw new StoreException.IO(key, "Problem when compressing content as " + compression + ": " + e.getMessage(), e);
            }
            if (compBytes.length >= origLength) {
                compression = null;
            } else {
                data = ByteContainer.simple((byte[])compBytes);
                metadata.compression = compression;
                metadata.uncompressedSize = origLength;
                metadata.storageSize = compBytes.length;
                metadata.compressedContentHash = StorableStoreImpl._calcChecksum(data);
            }
        }
        metadata.storageSize = data.byteLength();
        return this._putSmallEntry(source, diag, key, metadata, customMetadata, allowOverwrites, data);
    }

    protected StorableCreationResult _putSmallPreCompressedEntry(StoreOperationSource source, OperationDiagnostics diag, StorableKey key, StorableCreationMetadata metadata, ByteContainer customMetadata, OverwriteChecker allowOverwrites, ByteContainer data) throws IOException, StoreException {
        int origChecksum = metadata.contentHash;
        if (origChecksum == 0 && this._requireChecksumForPreCompressed) {
            throw new StoreException.Input(key, StoreException.InputProblem.BAD_CHECKSUM, "No checksum for non-compressed data provided for pre-compressed entry");
        }
        if (metadata.compression != Compression.NONE && metadata.compressedContentHash == 0) {
            metadata.compressedContentHash = StorableStoreImpl._calcChecksum(data);
        }
        return this._putSmallEntry(source, diag, key, metadata, customMetadata, allowOverwrites, data);
    }

    protected StorableCreationResult _putSmallEntry(StoreOperationSource source, final OperationDiagnostics diag, StorableKey key, StorableCreationMetadata stdMetadata, ByteContainer customMetadata, OverwriteChecker allowOverwrites, final ByteContainer data) throws IOException, StoreException {
        Storable storable;
        long creationTime;
        if (data.byteLength() <= this._maxInlinedStorageSize) {
            creationTime = this._timeMaster.currentTimeMillis();
            storable = this._storableConverter.encodeInlined(key, creationTime, stdMetadata, customMetadata, data);
        } else {
            long fileCreationTime = this._timeMaster.currentTimeMillis();
            FileReference fileRef = this._fileManager.createStorageFile(key, stdMetadata.compression, fileCreationTime);
            try {
                final long nanoStart = diag == null ? 0L : this._timeMaster.nanosForDiagnostics();
                this._throttler.performFileWrite(source, fileCreationTime, key, fileRef.getFile(), new FileOperationCallback<Void>(){

                    @Override
                    public Void perform(long operationTime, StorableKey key, Storable value, File externalFile) throws IOException, StoreException {
                        long fsStart = diag == null ? 0L : StorableStoreImpl.this._timeMaster.nanosForDiagnostics();
                        IOUtil.writeFile((File)externalFile, (ByteContainer)data);
                        if (diag != null) {
                            diag.addFileAccess(nanoStart, fsStart, StorableStoreImpl.this._timeMaster);
                        }
                        return null;
                    }
                });
            }
            catch (IOException e) {
                fileRef.getFile().delete();
                throw new StoreException.IO(key, "Failed to write storage file of " + data.byteLength() + " bytes: " + e.getMessage(), e);
            }
            creationTime = this._timeMaster.currentTimeMillis();
            storable = this._storableConverter.encodeOfflined(key, creationTime, stdMetadata, customMetadata, fileRef);
        }
        return this._putPartitionedEntry(source, diag, key, creationTime, stdMetadata, storable, allowOverwrites);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StorableCreationResult _putLargeEntry(StoreOperationSource source, OperationDiagnostics diag, StorableKey key, StorableCreationMetadata stdMetadata, ByteContainer customMetadata, OverwriteChecker allowOverwrites, byte[] readBuffer, int readByteCount, InputStream input) throws IOException, StoreException {
        boolean skipCompression;
        if (stdMetadata.compression != null) {
            skipCompression = true;
        } else if (!this._compressionEnabled || Compressors.isCompressed((byte[])readBuffer, (int)0, (int)readByteCount)) {
            skipCompression = true;
            stdMetadata.compression = Compression.NONE;
        } else {
            skipCompression = false;
            stdMetadata.compression = Compression.LZF;
        }
        StreamyBytesMemBuffer offHeap = this.allocOffHeapBuffer();
        try {
            StorableCreationResult storableCreationResult = this._putLargeEntry2(source, diag, key, stdMetadata, customMetadata, allowOverwrites, readBuffer, readByteCount, input, skipCompression, offHeap);
            return storableCreationResult;
        }
        finally {
            if (offHeap != null) {
                offHeap.close();
            }
        }
    }

    protected StorableCreationResult _putLargeEntry2(StoreOperationSource source, final OperationDiagnostics diag, StorableKey key, StorableCreationMetadata stdMetadata, ByteContainer customMetadata, OverwriteChecker allowOverwrites, final byte[] readBuffer, int incomingReadByteCount, final InputStream input, boolean skipCompression, final StreamyBytesMemBuffer offHeap) throws IOException, StoreException {
        OutputStream out;
        CountingOutputStream compressedOut;
        byte[] leftover;
        if (offHeap == null) {
            leftover = Arrays.copyOf(readBuffer, incomingReadByteCount);
        } else {
            if (offHeap != null && !offHeap.tryAppend(readBuffer, 0, incomingReadByteCount)) {
                throw new IOException("Internal problem: failed to append " + incomingReadByteCount + " in an off-heap buffer");
            }
            int overflow = this._readInBuffer(diag, key, input, readBuffer, offHeap);
            if (overflow == 0) {
                return this._putLargeEntryFullyBuffered(source, diag, key, stdMetadata, customMetadata, allowOverwrites, readBuffer, skipCompression, offHeap);
            }
            leftover = Arrays.copyOf(readBuffer, overflow);
        }
        long fileCreationTime = this._timeMaster.currentTimeMillis();
        FileReference fileRef = this._fileManager.createStorageFile(key, stdMetadata.compression, fileCreationTime);
        File storedFile = fileRef.getFile();
        if (skipCompression) {
            compressedOut = null;
            out = new FileOutputStream(storedFile);
        } else {
            compressedOut = new CountingOutputStream(new FileOutputStream(storedFile), (IncrementalHasher32)new IncrementalMurmur3Hasher());
            out = Compressors.compressingStream((OutputStream)compressedOut, (Compression)stdMetadata.compression);
        }
        final IncrementalMurmur3Hasher hasher = new IncrementalMurmur3Hasher(0);
        final long nanoStart = diag == null ? 0L : this._timeMaster.nanosForDiagnostics();
        long copiedBytes = this._throttler.performFileWrite(source, fileCreationTime, key, fileRef.getFile(), new FileOperationCallback<Long>(){

            @Override
            public Long perform(long operationTime, StorableKey key, Storable value, File externalFile) throws IOException, StoreException {
                long fsStart = diag == null ? 0L : StorableStoreImpl.this._timeMaster.nanosForDiagnostics();
                long copiedBytes = 0L;
                try {
                    int count;
                    if (offHeap != null) {
                        while ((count = offHeap.readIfAvailable(readBuffer)) > 0) {
                            out.write(readBuffer, 0, count);
                            copiedBytes += (long)count;
                            hasher.update(readBuffer, 0, count);
                        }
                    }
                    if (leftover != null) {
                        out.write(leftover);
                        hasher.update(leftover, 0, leftover.length);
                        copiedBytes += (long)leftover.length;
                    }
                    while (true) {
                        try {
                            count = input.read(readBuffer);
                        }
                        catch (IOException e) {
                            throw new StoreException.IO(key, "Failed to read content to store (after " + copiedBytes + " bytes)", e);
                        }
                        if (count < 0) {
                            break;
                        }
                        copiedBytes += (long)count;
                        try {
                            out.write(readBuffer, 0, count);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        hasher.update(readBuffer, 0, count);
                    }
                }
                catch (IOException e) {
                    if (copiedBytes == 0L) {
                        throw new StoreException.IO(key, "Failed to write initial bytes of file '" + externalFile.getAbsolutePath() + "'", e);
                    }
                    throw new StoreException.IO(key, "Failed to write intermediate bytes (after " + copiedBytes + ") to file '" + externalFile.getAbsolutePath() + "'", e);
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        StorableStoreImpl.this.LOG.warn("Failed to close file {}: {}", (Object)externalFile, (Object)e.getMessage());
                    }
                    if (diag != null) {
                        diag.addFileAccess(nanoStart, fsStart, StorableStoreImpl.this._timeMaster);
                    }
                }
                return copiedBytes;
            }
        });
        int contentHash = StorableStoreImpl._cleanChecksum(hasher.calculateHash());
        if (skipCompression) {
            this._verifyStorageSize(key, stdMetadata, copiedBytes);
            if (stdMetadata.compression == Compression.NONE) {
                this._verifyContentHash(key, stdMetadata, copiedBytes, contentHash);
            } else {
                this._verifyCompressedHash(key, stdMetadata, copiedBytes, contentHash);
            }
            stdMetadata.uncompressedSize = 0L;
        } else {
            int compressedHash = StorableStoreImpl._cleanChecksum(compressedOut.calculateHash());
            stdMetadata.uncompressedSize = copiedBytes;
            stdMetadata.storageSize = compressedOut.count();
            this._verifyContentHash(key, stdMetadata, copiedBytes, contentHash);
            this._verifyCompressedHash(key, stdMetadata, copiedBytes, compressedHash);
        }
        long creationTime = this._timeMaster.currentTimeMillis();
        Storable storable = this._storableConverter.encodeOfflined(key, creationTime, stdMetadata, customMetadata, fileRef);
        return this._putPartitionedEntry(source, diag, key, creationTime, stdMetadata, storable, allowOverwrites);
    }

    protected StorableCreationResult _putLargeEntryFullyBuffered(StoreOperationSource source, final OperationDiagnostics diag, StorableKey key, StorableCreationMetadata stdMetadata, ByteContainer customMetadata, OverwriteChecker allowOverwrites, final byte[] readBuffer, boolean skipCompression, final StreamyBytesMemBuffer offHeap) throws IOException, StoreException {
        OutputStream out;
        CountingOutputStream compressedOut;
        long fileCreationTime = this._timeMaster.currentTimeMillis();
        FileReference fileRef = this._fileManager.createStorageFile(key, stdMetadata.compression, fileCreationTime);
        File storedFile = fileRef.getFile();
        if (skipCompression) {
            compressedOut = null;
            out = new FileOutputStream(storedFile);
        } else {
            compressedOut = new CountingOutputStream(new FileOutputStream(storedFile), (IncrementalHasher32)new IncrementalMurmur3Hasher());
            out = Compressors.compressingStream((OutputStream)compressedOut, (Compression)stdMetadata.compression);
        }
        final IncrementalMurmur3Hasher hasher = new IncrementalMurmur3Hasher(0);
        final long nanoStart = diag == null ? 0L : this._timeMaster.nanosForDiagnostics();
        long copiedBytes = this._throttler.performFileWrite(source, fileCreationTime, key, fileRef.getFile(), new FileOperationCallback<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long perform(long operationTime, StorableKey key, Storable value, File externalFile) throws IOException, StoreException {
                long fsStart = diag == null ? 0L : StorableStoreImpl.this._timeMaster.nanosForDiagnostics();
                long copiedBytes = 0L;
                try {
                    int count;
                    while ((count = offHeap.readIfAvailable(readBuffer)) > 0) {
                        copiedBytes += (long)count;
                        try {
                            out.write(readBuffer, 0, count);
                        }
                        catch (IOException e) {
                            throw new StoreException.IO(key, "Failed to write " + count + " bytes (after " + copiedBytes + ") to file '" + externalFile.getAbsolutePath() + "'", e);
                        }
                        hasher.update(readBuffer, 0, count);
                    }
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                    if (diag != null) {
                        diag.addFileAccess(nanoStart, fsStart, StorableStoreImpl.this._timeMaster);
                    }
                }
                return copiedBytes;
            }
        });
        int contentHash = StorableStoreImpl._cleanChecksum(hasher.calculateHash());
        if (skipCompression) {
            this._verifyStorageSize(key, stdMetadata, copiedBytes);
            if (stdMetadata.compression == Compression.NONE) {
                this._verifyContentHash(key, stdMetadata, copiedBytes, contentHash);
            } else {
                this._verifyCompressedHash(key, stdMetadata, copiedBytes, contentHash);
            }
            stdMetadata.uncompressedSize = 0L;
        } else {
            int compressedHash = StorableStoreImpl._cleanChecksum(compressedOut.calculateHash());
            stdMetadata.uncompressedSize = copiedBytes;
            stdMetadata.storageSize = compressedOut.count();
            this._verifyContentHash(key, stdMetadata, copiedBytes, contentHash);
            this._verifyCompressedHash(key, stdMetadata, copiedBytes, compressedHash);
        }
        long creationTime = this._timeMaster.currentTimeMillis();
        Storable storable = this._storableConverter.encodeOfflined(key, creationTime, stdMetadata, customMetadata, fileRef);
        return this._putPartitionedEntry(source, diag, key, creationTime, stdMetadata, storable, allowOverwrites);
    }

    protected void _verifyStorageSize(StorableKey key, StorableCreationMetadata stdMetadata, long bytes) throws StoreException {
        if (stdMetadata.storageSize != bytes && stdMetadata.storageSize >= 0L) {
            throw new StoreException.Input(key, StoreException.InputProblem.BAD_LENGTH, "Incorrect length for entry; storageSize=" + stdMetadata.storageSize + ", bytes read: " + bytes);
        }
        stdMetadata.storageSize = bytes;
    }

    protected void _verifyContentHash(StorableKey key, StorableCreationMetadata stdMetadata, long bytes, int contentHash) throws StoreException {
        if (stdMetadata.contentHash == 0) {
            stdMetadata.contentHash = contentHash;
        } else if (stdMetadata.contentHash != contentHash) {
            throw new StoreException.Input(key, StoreException.InputProblem.BAD_CHECKSUM, "Incorrect content checksum for entry (compression: " + stdMetadata.compression + ", " + bytes + " bytes): got 0x" + Integer.toHexString(stdMetadata.contentHash) + ", calculated to be 0x" + Integer.toHexString(contentHash));
        }
    }

    protected void _verifyCompressedHash(StorableKey key, StorableCreationMetadata stdMetadata, long bytes, int contentHash) throws StoreException {
        if (stdMetadata.compressedContentHash == 0) {
            stdMetadata.compressedContentHash = contentHash;
        } else if (stdMetadata.compressedContentHash != contentHash) {
            throw new StoreException.Input(key, StoreException.InputProblem.BAD_CHECKSUM, "Incorrect compressed checksum for " + stdMetadata.compression + " entry (" + bytes + " bytes): got 0x" + Integer.toHexString(stdMetadata.compressedContentHash) + ", calculated to be 0x" + Integer.toHexString(contentHash));
        }
    }

    protected int _readInBuffer(OperationDiagnostics diag, StorableKey key, InputStream input, byte[] readBuffer, StreamyBytesMemBuffer offHeap) throws IOException {
        long nanoStart = diag == null ? 0L : this._timeMaster.nanosForDiagnostics();
        try {
            while (true) {
                int count;
                try {
                    count = input.read(readBuffer);
                }
                catch (IOException e) {
                    throw new StoreException.IO(key, "Failed to read content to store (after " + offHeap.getTotalPayloadLength() + " bytes)", e);
                }
                if (count < 0) {
                    int n = 0;
                    return n;
                }
                if (offHeap.tryAppend(readBuffer, 0, count)) continue;
                int n = count;
                return n;
            }
        }
        finally {
            if (diag != null) {
                diag.addRequestReadTime(nanoStart, this._timeMaster);
            }
        }
    }

    protected StorableCreationResult _putPartitionedEntry(StoreOperationSource source, final OperationDiagnostics diag, StorableKey key, long operationTime, StorableCreationMetadata stdMetadata, Storable storable, final OverwriteChecker allowOverwrites) throws IOException, StoreException {
        FileReference ref;
        final long nanoStart = diag == null ? 0L : this._timeMaster.nanosForDiagnostics();
        StorableCreationResult result = this._throttler.performPut(source, operationTime, key, storable, new StoreOperationCallback<StorableCreationResult>(){

            @Override
            public StorableCreationResult perform(long time, StorableKey key, final Storable newValue) throws IOException, StoreException {
                Boolean defaultOk = allowOverwrites.mayOverwrite(key);
                if (defaultOk != null) {
                    if (defaultOk.booleanValue()) {
                        return StorableStoreImpl.this._writeMutex.partitionedWrite(time, key, new PartitionedWriteMutex.Callback<StorableCreationResult>(){

                            @Override
                            public StorableCreationResult performWrite(StorableKey key) throws IOException, StoreException {
                                long dbStart = diag == null ? 0L : StorableStoreImpl.this._timeMaster.nanosForDiagnostics();
                                Storable oldValue = StorableStoreImpl.this._backend.putEntry(key, newValue);
                                if (diag != null) {
                                    diag.addDbAccess(nanoStart, dbStart, StorableStoreImpl.this._timeMaster.nanosForDiagnostics());
                                }
                                return new StorableCreationResult(key, true, newValue, oldValue);
                            }
                        });
                    }
                    return StorableStoreImpl.this._writeMutex.partitionedWrite(time, key, new PartitionedWriteMutex.Callback<StorableCreationResult>(){

                        @Override
                        public StorableCreationResult performWrite(StorableKey key) throws IOException, StoreException {
                            long dbStart = diag == null ? 0L : StorableStoreImpl.this._timeMaster.nanosForDiagnostics();
                            Storable oldValue = StorableStoreImpl.this._backend.createEntry(key, newValue);
                            if (diag != null) {
                                diag.addDbAccess(nanoStart, dbStart, StorableStoreImpl.this._timeMaster.nanosForDiagnostics());
                            }
                            if (oldValue == null) {
                                return new StorableCreationResult(key, true, newValue, null);
                            }
                            return new StorableCreationResult(key, false, newValue, oldValue);
                        }
                    });
                }
                return StorableStoreImpl.this._writeMutex.partitionedWrite(time, key, new PartitionedWriteMutex.Callback<StorableCreationResult>(){

                    @Override
                    public StorableCreationResult performWrite(StorableKey key) throws IOException, StoreException {
                        AtomicReference<Storable> oldEntryRef = new AtomicReference<Storable>();
                        long dbStart = diag == null ? 0L : StorableStoreImpl.this._timeMaster.nanosForDiagnostics();
                        boolean success = StorableStoreImpl.this._backend.upsertEntry(key, newValue, allowOverwrites, oldEntryRef);
                        if (diag != null) {
                            diag.addDbAccess(nanoStart, dbStart, StorableStoreImpl.this._timeMaster.nanosForDiagnostics());
                        }
                        if (!success) {
                            return new StorableCreationResult(key, false, newValue, oldEntryRef.get());
                        }
                        return new StorableCreationResult(key, true, newValue, oldEntryRef.get());
                    }
                });
            }
        });
        if (!result.succeeded() && (ref = stdMetadata.dataFile) != null) {
            this._deleteBackingFile(key, ref.getFile());
        }
        return result;
    }

    @Override
    public StorableDeletionResult softDelete(final StoreOperationSource source, final OperationDiagnostics diag, StorableKey key, final boolean removeInlinedData, final boolean removeExternalData) throws IOException, StoreException {
        this._checkClosed();
        final long nanoStart = diag == null ? 0L : this._timeMaster.nanosForDiagnostics();
        Storable entry = this._throttler.performSoftDelete(source, this._timeMaster.currentTimeMillis(), key, new StoreOperationCallback<Storable>(){

            @Override
            public Storable perform(final long operationTime, StorableKey key, Storable value) throws IOException, StoreException {
                return StorableStoreImpl.this._writeMutex.partitionedWrite(operationTime, key, new PartitionedWriteMutex.Callback<Storable>(){

                    @Override
                    public Storable performWrite(StorableKey key) throws IOException, StoreException {
                        long dbStart = diag == null ? 0L : StorableStoreImpl.this._timeMaster.nanosForDiagnostics();
                        Storable value = StorableStoreImpl.this._backend.findEntry(key);
                        if (value == null) {
                            return null;
                        }
                        return StorableStoreImpl.this._softDelete(source, diag, nanoStart, dbStart, key, value, operationTime, removeInlinedData, removeExternalData);
                    }
                });
            }
        });
        return new StorableDeletionResult(key, entry);
    }

    @Override
    public StorableDeletionResult hardDelete(final StoreOperationSource source, final OperationDiagnostics diag, StorableKey key, final boolean removeExternalData) throws IOException, StoreException {
        this._checkClosed();
        final long nanoStart = diag == null ? 0L : this._timeMaster.nanosForDiagnostics();
        Storable entry = this._throttler.performHardDelete(source, this._timeMaster.currentTimeMillis(), key, new StoreOperationCallback<Storable>(){

            @Override
            public Storable perform(long operationTime, StorableKey key, Storable value) throws IOException, StoreException {
                return StorableStoreImpl.this._writeMutex.partitionedWrite(operationTime, key, new PartitionedWriteMutex.Callback<Storable>(){

                    @Override
                    public Storable performWrite(StorableKey key) throws IOException, StoreException {
                        long dbStart = diag == null ? 0L : StorableStoreImpl.this._timeMaster.nanosForDiagnostics();
                        Storable value = StorableStoreImpl.this._backend.findEntry(key);
                        if (value == null) {
                            return null;
                        }
                        return StorableStoreImpl.this._hardDelete(source, diag, nanoStart, dbStart, key, value, removeExternalData);
                    }
                });
            }
        });
        return new StorableDeletionResult(key, entry);
    }

    protected Storable _softDelete(StoreOperationSource source, OperationDiagnostics diag, long nanoStart, long dbStart, StorableKey key, Storable entry, long currentTime, boolean removeInlinedData, boolean removeExternalData) throws IOException, StoreException {
        boolean hasExternalToDelete;
        boolean bl = hasExternalToDelete = removeExternalData && entry.hasExternalData();
        if (!entry.isDeleted() || hasExternalToDelete || removeInlinedData && entry.hasInlineData()) {
            File extFile = hasExternalToDelete ? entry.getExternalFile(this._fileManager) : null;
            Storable modifiedEntry = this._storableConverter.softDeletedCopy(key, entry, currentTime, removeInlinedData, removeExternalData);
            this._backend.ovewriteEntry(key, modifiedEntry);
            if (diag != null) {
                diag.addDbAccess(nanoStart, dbStart, this._timeMaster.nanosForDiagnostics());
            }
            if (extFile != null) {
                this._deleteBackingFile(key, extFile);
            }
            return modifiedEntry;
        }
        return entry;
    }

    protected Storable _hardDelete(StoreOperationSource source, OperationDiagnostics diag, long nanoStart, long dbStart, StorableKey key, Storable entry, boolean removeExternalData) throws IOException, StoreException {
        this._backend.deleteEntry(key);
        if (diag != null) {
            diag.addDbAccess(nanoStart, dbStart, this._timeMaster.nanosForDiagnostics());
        }
        if (removeExternalData && entry.hasExternalData()) {
            this._deleteBackingFile(key, entry.getExternalFile(this._fileManager));
        }
        return entry;
    }

    @Override
    public IterationResult iterateEntriesByKey(StoreOperationSource source, final OperationDiagnostics diag, final StorableKey firstKey, final StorableIterationCallback cb) throws StoreException {
        final long nanoStart = diag == null ? 0L : this._timeMaster.nanosForDiagnostics();
        try {
            return this._throttler.performList(source, this._timeMaster.currentTimeMillis(), new StoreOperationCallback<IterationResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IterationResult perform(long operationTime, StorableKey key, Storable value) throws IOException, StoreException {
                    long dbStart = diag == null ? 0L : StorableStoreImpl.this._timeMaster.nanosForDiagnostics();
                    try {
                        IterationResult iterationResult = StorableStoreImpl.this._backend.iterateEntriesByKey(cb, firstKey);
                        return iterationResult;
                    }
                    finally {
                        if (diag != null) {
                            diag.addDbAccess(nanoStart, dbStart, StorableStoreImpl.this._timeMaster.nanosForDiagnostics());
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw new StoreException.IO(firstKey, "Failed to iterate entries from " + firstKey + ": " + e.getMessage(), e);
        }
    }

    @Override
    public IterationResult iterateEntriesAfterKey(StoreOperationSource source, final OperationDiagnostics diag, final StorableKey lastSeen, final StorableIterationCallback cb) throws StoreException {
        final long nanoStart = diag == null ? 0L : this._timeMaster.nanosForDiagnostics();
        try {
            return this._throttler.performList(source, this._timeMaster.currentTimeMillis(), new StoreOperationCallback<IterationResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IterationResult perform(long operationTime, StorableKey key, Storable value) throws IOException, StoreException {
                    long dbStart = diag == null ? 0L : StorableStoreImpl.this._timeMaster.nanosForDiagnostics();
                    try {
                        if (lastSeen == null) {
                            IterationResult iterationResult = StorableStoreImpl.this._backend.iterateEntriesByKey(cb, null);
                            return iterationResult;
                        }
                        IterationResult iterationResult = StorableStoreImpl.this._backend.iterateEntriesAfterKey(cb, lastSeen);
                        return iterationResult;
                    }
                    finally {
                        if (diag != null) {
                            diag.addDbAccess(nanoStart, dbStart, StorableStoreImpl.this._timeMaster.nanosForDiagnostics());
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw new StoreException.IO(lastSeen, "Failed to iterate entries from " + lastSeen + ": " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IterationResult iterateEntriesByModifiedTime(StoreOperationSource source, OperationDiagnostics diag, long firstTimestamp, StorableLastModIterationCallback cb) throws StoreException {
        long nanoStart = diag == null ? 0L : this._timeMaster.nanosForDiagnostics();
        try {
            IterationResult iterationResult = this._backend.iterateEntriesByModifiedTime(cb, firstTimestamp);
            return iterationResult;
        }
        finally {
            if (diag != null) {
                diag.addDbAccess(nanoStart, nanoStart, this._timeMaster.nanosForDiagnostics());
            }
        }
    }

    @Override
    public int getInFlightWritesCount() {
        return this._writeMutex.getInFlightWritesCount();
    }

    @Override
    public long getTombstoneCount(StoreOperationSource source, long maxRuntimeMsecs) throws StoreException {
        long maxMax;
        long startTime = this._timeMaster.currentTimeMillis();
        long maxEndTime = startTime + Math.min(maxMax = Long.MAX_VALUE - startTime, maxRuntimeMsecs);
        TombstoneCounter counter = new TombstoneCounter(this._timeMaster, maxEndTime);
        if (this._backend.scanEntries(counter) != IterationResult.FULLY_ITERATED) {
            throw new IllegalStateException("getTombstoneCount() run too long (max " + maxRuntimeMsecs + "); failed after " + counter.tombstones + "/" + counter.total + " records");
        }
        return counter.tombstones;
    }

    @Override
    public List<Storable> dumpEntries(StoreOperationSource source, final int maxCount, final boolean includeDeleted) throws StoreException {
        final ArrayList<Storable> result = new ArrayList<Storable>();
        if (maxCount > 0) {
            this._backend.iterateEntriesByKey(new StorableIterationCallback(){

                @Override
                public IterationAction verifyKey(StorableKey key) {
                    return IterationAction.PROCESS_ENTRY;
                }

                @Override
                public IterationAction processEntry(Storable entry) {
                    if (includeDeleted || !entry.isDeleted()) {
                        result.add(entry);
                        if (result.size() >= maxCount) {
                            return IterationAction.TERMINATE_ITERATION;
                        }
                    }
                    return IterationAction.PROCESS_ENTRY;
                }
            });
        }
        return result;
    }

    @Override
    public List<Storable> dumpOldestEntries(StoreOperationSource source, final int maxCount, long fromTime, final boolean includeDeleted) throws StoreException {
        final ArrayList<Storable> result = new ArrayList<Storable>();
        if (maxCount > 0) {
            this._backend.iterateEntriesByModifiedTime(new StorableLastModIterationCallback(){

                @Override
                public IterationAction verifyTimestamp(long timestamp) {
                    return IterationAction.PROCESS_ENTRY;
                }

                @Override
                public IterationAction verifyKey(StorableKey key) {
                    return IterationAction.PROCESS_ENTRY;
                }

                @Override
                public IterationAction processEntry(Storable entry) {
                    if (includeDeleted || !entry.isDeleted()) {
                        result.add(entry);
                        if (result.size() >= maxCount) {
                            return IterationAction.TERMINATE_ITERATION;
                        }
                    }
                    return IterationAction.PROCESS_ENTRY;
                }
            }, fromTime);
        }
        return result;
    }

    @Override
    public int removeEntries(StoreOperationSource source, int maxToRemove) throws IOException, StoreException {
        int removed = 0;
        if (maxToRemove > 0) {
            StorableCollector collector = new StorableCollector(maxToRemove){

                @Override
                public boolean includeEntry(Storable entry) {
                    return true;
                }
            };
            for (StorableKey key : collector.getCollected()) {
                this.hardDelete(source, null, key, true);
                ++removed;
            }
        }
        return removed;
    }

    @Override
    public int removeTombstones(StoreOperationSource source, int maxToRemove) throws IOException, StoreException {
        int removed = 0;
        if (maxToRemove > 0) {
            StorableCollector collector = new StorableCollector(maxToRemove){

                @Override
                public boolean includeEntry(Storable entry) {
                    return entry.isDeleted();
                }
            };
            this._backend.iterateEntriesByKey(collector);
            for (StorableKey key : collector.getCollected()) {
                this.hardDelete(source, null, key, true);
                ++removed;
            }
        }
        return removed;
    }

    protected void _deleteBackingFile(StorableKey key, File extFile) {
        if (extFile != null) {
            try {
                boolean ok = extFile.delete();
                if (!ok) {
                    this.LOG.warn("Failed to delete backing data file of key {}, path: {}", (Object)key, (Object)extFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                this.LOG.warn("Failed to delete backing data file of key " + key + ", path: " + extFile.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    protected static int _calcChecksum(ByteContainer data) {
        return StorableStoreImpl._cleanChecksum(data.hash((BlockHasher32)BlockMurmur3Hasher.instance, 0));
    }

    protected static int _cleanChecksum(int checksum) {
        return checksum == 0 ? 1 : checksum;
    }

    protected boolean _shouldTryToCompress(StorableCreationMetadata metadata, ByteContainer data) {
        return this._compressionEnabled && metadata.compression == null && data.byteLength() >= this._minCompressibleSize && !Compressors.isCompressed((ByteContainer)data);
    }

    protected void _checkClosed() {
        if (this._closed.get()) {
            throw new IllegalStateException("Can not access data from StorableStore after it has been closed");
        }
    }
}

