/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.util;

import com.fasterxml.storemate.shared.TimeMaster;
import com.fasterxml.storemate.store.Storable;
import com.fasterxml.storemate.store.util.TotalTime;

public class OperationDiagnostics {
    protected final long _nanoStart;
    protected Storable _entry;
    protected int _itemCount;
    protected TotalTime _dbAccess;
    protected TotalTime _dbAccessTotal;
    protected TotalTime _fileAccess;
    protected TotalTime _fileAccessTotal;
    protected long _requestResponseTotal;

    public OperationDiagnostics(long nanoStart) {
        this._nanoStart = nanoStart;
    }

    public OperationDiagnostics(TimeMaster tm) {
        this(tm.currentTimeMillis());
    }

    public OperationDiagnostics setEntry(Storable e) {
        this._entry = e;
        return this;
    }

    public OperationDiagnostics setItemCount(int count) {
        this._itemCount = count;
        return this;
    }

    public void addDbAccess(long nanoStart, long nanoDbStart, TimeMaster timeMaster) {
        this.addDbAccess(nanoStart, nanoDbStart, timeMaster.nanosForDiagnostics());
    }

    public void addDbAccess(long nanoStart, long nanoDbStart, long endTime) {
        long rawTime = endTime - nanoDbStart;
        long timeWithWait = endTime - nanoStart;
        this._dbAccess = TotalTime.createOrAdd(this._dbAccess, rawTime, timeWithWait);
    }

    public void addFileAccess(long nanoStart, long nanoFileStart, TimeMaster timeMaster) {
        this.addFileAccess(nanoStart, nanoFileStart, timeMaster.nanosForDiagnostics());
    }

    public void addFileAccess(long nanoStart, long nanoFileStart, long endTime) {
        long rawTime = endTime - nanoFileStart;
        long timeWithWait = endTime - nanoStart;
        this._fileAccess = TotalTime.createOrAdd(this._fileAccess, rawTime, timeWithWait);
    }

    public void addFileWait(long waitTime) {
        this._fileAccess = TotalTime.createOrAdd(this._fileAccess, 0L, waitTime);
    }

    public void addRequestReadTime(long nanoStart, TimeMaster tm) {
        this.addRequestReadTime(nanoStart, tm.nanosForDiagnostics());
    }

    public void addRequestReadTime(long nanoStart, long nanoEnd) {
        this._requestResponseTotal += nanoEnd - nanoStart;
    }

    public void addResponseWriteTime(long nanoStart, TimeMaster tm) {
        this.addResponseWriteTime(nanoStart, tm.nanosForDiagnostics());
    }

    public void addResponseWriteTime(long nanoStart, long nanoEnd) {
        this.addResponseWriteTime(nanoEnd - nanoStart);
    }

    public void addResponseWriteTime(long nanoSecs) {
        this._requestResponseTotal += nanoSecs;
    }

    public Storable getEntry() {
        return this._entry;
    }

    public int getItemCount() {
        return this._itemCount;
    }

    public long getNanosSpent() {
        return System.nanoTime() - this._nanoStart;
    }

    public boolean hasDbAccess() {
        return this._dbAccess != null;
    }

    public boolean hasFileAccess() {
        return this._fileAccess != null;
    }

    public boolean hasRequestResponseTotal() {
        return this._requestResponseTotal > 0L;
    }

    public long getRequestResponseTotal() {
        return this._requestResponseTotal;
    }

    public TotalTime getDbAccess() {
        return this._dbAccess;
    }

    public TotalTime getFileAccess() {
        return this._fileAccess;
    }
}

