/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.storemate.store.util;

import com.fasterxml.storemate.shared.ByteContainer;
import com.fasterxml.storemate.shared.util.WithBytesCallback;

public abstract class StuffToBytes {
    public static final int MAX_VLONG_LENGTH = 9;
    public static final int MAX_VINT_LENGTH = 5;
    public static final int BASE_LENGTH = 16;
    public static final byte ZERO_LENGTH_AS_BYTE = -128;
    protected int _ptr;

    protected StuffToBytes() {
    }

    public static StuffToBytes writer(int maxLen) {
        return new Writer(maxLen);
    }

    public static StuffToBytes estimator() {
        return new Estimator();
    }

    public final int offset() {
        return this._ptr;
    }

    public abstract StuffToBytes appendByte(byte var1);

    public abstract StuffToBytes appendInt(int var1);

    public abstract StuffToBytes appendLong(long var1);

    public abstract StuffToBytes appendVInt(int var1);

    public abstract StuffToBytes appendVLong(long var1);

    public final StuffToBytes appendBytes(byte[] data) {
        return this.appendBytes(data, 0, data.length);
    }

    public abstract StuffToBytes appendBytes(byte[] var1, int var2, int var3);

    public abstract <T> T withResult(WithBytesCallback<T> var1);

    public abstract StuffToBytes appendLengthAndBytes(ByteContainer var1);

    public abstract ByteContainer bufferedBytes();

    protected static class Estimator
    extends StuffToBytes {
        protected Estimator() {
        }

        @Override
        public <T> T withResult(WithBytesCallback<T> cb) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteContainer bufferedBytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StuffToBytes appendByte(byte b) {
            ++this._ptr;
            return this;
        }

        @Override
        public StuffToBytes appendLong(long l) {
            this._ptr += 8;
            return this;
        }

        @Override
        public StuffToBytes appendInt(int i) {
            this._ptr += 4;
            return this;
        }

        @Override
        public StuffToBytes appendVInt(int i) {
            if (i <= 127) {
                ++this._ptr;
                return this;
            }
            do {
                ++this._ptr;
            } while ((i >>>= 7) != 0);
            return this;
        }

        @Override
        public StuffToBytes appendVLong(long l) {
            if (l < Integer.MAX_VALUE) {
                return this.appendVInt((int)l);
            }
            this._ptr += 5;
            int rem = (int)(l >>> 35);
            while (rem > 0) {
                rem >>>= 7;
                ++this._ptr;
            }
            return this;
        }

        @Override
        public StuffToBytes appendBytes(byte[] data, int offset, int length) {
            this._ptr += length;
            return this;
        }

        @Override
        public StuffToBytes appendLengthAndBytes(ByteContainer bytes) {
            if (bytes == null) {
                ++this._ptr;
            } else {
                int len = bytes.byteLength();
                this.appendVInt(len);
                this._ptr += len;
            }
            return this;
        }
    }

    protected static class Writer
    extends StuffToBytes
    implements WithBytesCallback<StuffToBytes> {
        protected final byte[] _buffer = new byte[maxLen += 9];
        protected final int _end;

        protected Writer(int maxLen) {
            this._end = maxLen;
        }

        @Override
        public <T> T withResult(WithBytesCallback<T> cb) {
            return (T)cb.withBytes(this._buffer, 0, this._ptr);
        }

        @Override
        public ByteContainer bufferedBytes() {
            return ByteContainer.simple((byte[])this._buffer, (int)0, (int)this._ptr);
        }

        @Override
        public StuffToBytes appendByte(byte b) {
            if (this._ptr >= this._end) {
                this._reportBounds(1);
            }
            this._buffer[this._ptr++] = b;
            return this;
        }

        @Override
        public StuffToBytes appendLong(long l) {
            this._verifyBounds(8);
            this._appendInt((int)(l >>> 32));
            this._appendInt((int)l);
            return this;
        }

        @Override
        public StuffToBytes appendInt(int i) {
            this._verifyBounds(4);
            this._appendInt(i);
            return this;
        }

        @Override
        public StuffToBytes appendVInt(int value) {
            int start;
            if (value < 0) {
                throw new IllegalArgumentException();
            }
            if (value <= 127) {
                this._buffer[this._ptr++] = (byte)(value | 0x80);
                return this;
            }
            int end = start = this._ptr;
            int tmp = value >>> 7;
            while (tmp > 0) {
                tmp >>>= 7;
                ++end;
            }
            this._ptr = end + 1;
            this._buffer[end] = (byte)(value & 0x7F | 0x80);
            do {
                this._buffer[--end] = (byte)((value >>>= 7) & 0x7F);
            } while (end > start);
            return this;
        }

        @Override
        public StuffToBytes appendVLong(long value) {
            if (value < 0L) {
                throw new IllegalArgumentException("Can not encode negative values, got: " + value);
            }
            if (value < Integer.MAX_VALUE) {
                return this.appendVInt((int)value);
            }
            int start = this._ptr;
            int end = start + 4;
            int tmp = (int)(value >>> 35);
            while (tmp > 0) {
                tmp >>>= 7;
                ++end;
            }
            this._ptr = end + 1;
            this._buffer[end] = (byte)(value & 0x7FL | 0x80L);
            do {
                this._buffer[--end] = (byte)((value >>>= 7) & 0x7FL);
            } while (end > start);
            return this;
        }

        @Override
        public StuffToBytes appendBytes(byte[] data, int offset, int length) {
            this._verifyBounds(length);
            System.arraycopy(data, offset, this._buffer, this._ptr, length);
            this._ptr += length;
            return this;
        }

        @Override
        public StuffToBytes appendLengthAndBytes(ByteContainer bytes) {
            if (bytes == null) {
                this.appendVInt(0);
                return this;
            }
            this.appendVInt(bytes.byteLength());
            bytes.withBytes((WithBytesCallback)this);
            return this;
        }

        public StuffToBytes withBytes(byte[] buffer, int offset, int length) {
            return this.appendBytes(buffer, offset, length);
        }

        protected void _appendInt(int i) {
            int ptr = this._ptr;
            byte[] buf = this._buffer;
            buf[ptr++] = (byte)(i >> 24);
            buf[ptr++] = (byte)(i >> 16);
            buf[ptr++] = (byte)(i >> 8);
            buf[ptr++] = (byte)i;
            this._ptr = ptr;
        }

        protected void _verifyBounds(int bytesNeeded) {
            if (this._ptr + bytesNeeded > this._end) {
                this._reportBounds(bytesNeeded);
            }
        }

        protected void _reportBounds(int bytesNeeded) {
            int left = this._end - this._ptr;
            throw new IllegalStateException("Buffer overrun: need " + bytesNeeded + "; only have " + left + " (offset " + this._ptr + ")");
        }
    }
}

